/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;

final class CQCreateEagerQuery
extends CQWorker {
    CQCreateEagerQuery() {
    }

    @Override
    CompletionStage<QueryResponse> perform(BitSet segments) {
        SearchQueryBuilder query = this.queryDefinition.getSearchQueryBuilder();
        this.setFilter(segments);
        CompletionStage<NodeTopDocs> nodeTopDocs = query.aggregation() != null ? this.collectAggregations(query) : (query.isEntityProjection() ? this.collectKeys(query, this.queryDefinition.isScoreRequired()) : this.collectProjections(query));
        return nodeTopDocs.thenApply(QueryResponse::new);
    }

    private LuceneSearchResult<?> fetchHits(SearchQueryBuilder query) {
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        LuceneSearchResult result = (LuceneSearchResult)query.build().fetch(Integer.valueOf(this.queryDefinition.getMaxResults()));
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.localIndexedQueryExecuted(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return result;
    }

    public LuceneSearchResult<Object> fetchIds(SearchQueryBuilder query) {
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        LuceneSearchResult result = (LuceneSearchResult)query.ids().fetch(Integer.valueOf(this.queryDefinition.getMaxResults()));
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.localIndexedQueryExecuted(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return result;
    }

    public LuceneSearchResult<List<Object>> fetchIdAndScore(SearchQueryBuilder query) {
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        LuceneSearchResult result = (LuceneSearchResult)query.idAndScore().fetch(Integer.valueOf(this.queryDefinition.getMaxResults()));
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.localIndexedQueryExecuted(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return result;
    }

    private CompletionStage<NodeTopDocs> collectKeys(SearchQueryBuilder query, boolean scoreRequired) {
        if (scoreRequired) {
            return this.blockingManager.supplyBlocking(() -> this.fetchIdAndScore(query), (Object)"CQCreateEagerQuery#collectKeys").thenApply(queryResult -> {
                SearchResultTotal total = queryResult.total();
                int hitCount = Math.toIntExact(total.hitCountLowerBound());
                boolean countIsExact = total.isHitCountExact();
                Object[] keys = queryResult.hits().stream().map(objects -> objects.get(0)).toArray(Object[]::new);
                return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), hitCount, countIsExact, keys, null);
            });
        }
        return this.blockingManager.supplyBlocking(() -> this.fetchIds(query), (Object)"CQCreateEagerQuery#collectKeys").thenApply(queryResult -> {
            SearchResultTotal total = queryResult.total();
            int hitCount = Math.toIntExact(total.hitCountLowerBound());
            boolean countIsExact = total.isHitCountExact();
            Object[] keys = queryResult.hits().stream().toArray(Object[]::new);
            return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), hitCount, countIsExact, keys, null);
        });
    }

    private CompletionStage<NodeTopDocs> collectProjections(SearchQueryBuilder query) {
        return this.blockingManager.supplyBlocking(() -> this.fetchHits(query), (Object)"CQCreateEagerQuery#collectProjections").thenApply(queryResult -> {
            SearchResultTotal total = queryResult.total();
            int hitCount = Math.toIntExact(total.hitCountLowerBound());
            boolean countIsExact = total.isHitCountExact();
            List hits = queryResult.hits();
            Object[] projections = hits.toArray(new Object[0]);
            return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), hitCount, countIsExact, null, projections);
        });
    }

    private CompletionStage<NodeTopDocs> collectAggregations(SearchQueryBuilder query) {
        boolean displayGroupFirst = query.aggregation().displayGroupFirst();
        return this.blockingManager.supplyBlocking(() -> this.fetchHits(query), (Object)"CQCreateEagerQuery#collectAggregations").thenApply(queryResult -> {
            Map aggregation = (Map)queryResult.aggregation(AggregationKey.of((String)"InfinispanSingletonKey"));
            ArrayList<Object[]> hits = new ArrayList<Object[]>(aggregation.size());
            for (Map.Entry groupAggregation : aggregation.entrySet()) {
                if (displayGroupFirst) {
                    hits.add(new Object[]{groupAggregation.getKey(), groupAggregation.getValue()});
                    continue;
                }
                hits.add(new Object[]{groupAggregation.getValue(), groupAggregation.getKey()});
            }
            Object[] projections = hits.toArray(new Object[0]);
            return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), hits.size(), true, null, projections);
        });
    }
}

