/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.logging;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=28001, max=28500)
public interface Log
extends BasicLogger {
    @Message(value="Querying is not enabled on cache %s", id=28004)
    public CacheException queryingNotEnabled(String var1);

    @Message(value="The key must be a String : %s", id=28007)
    public CacheException keyMustBeString(Class<?> var1);

    @Message(value="The value must be a String : %s", id=28008)
    public CacheException valueMustBeString(Class<?> var1);

    @Message(value="The key must be a String ending with \".proto\" : %s", id=28009)
    public CacheException keyMustBeStringEndingWithProto(Object var1);

    @Message(value="Failed to parse proto file.", id=28010)
    public CacheException failedToParseProtoFile(@Cause Throwable var1);

    @Message(value="Failed to parse proto file : %s", id=28011)
    public CacheException failedToParseProtoFile(String var1, @Cause Throwable var2);

    @Message(value="Error during execution of protostream serialization context initializer", id=28013)
    public CacheException errorInitializingSerCtx(@Cause Throwable var1);

    @Message(value="The '%s' cache does not support commands of type %s", id=28014)
    public CacheException cacheDoesNotSupportCommand(String var1, String var2);

    @Message(value="Cache '%s' with storage type '%s' cannot be queried. Please configure the cache encoding as 'application/x-protostream' or 'application/x-java-object'", id=28015)
    public CacheException cacheNotQueryable(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=28016, value="Query performed in a cache ('%s') that has an unknown format configuration. Please configure the cache encoding as 'application/x-protostream' or 'application/x-java-object'")
    public void warnNoMediaType(String var1);

    @Message(id=28018, value="It is not possible to create indexes for a field having type %s. Field: %s.")
    public CacheException fieldTypeNotIndexable(String var1, String var2);

    @Message(id=28021, value="The configured indexed-entity type '%s' must be indexed. Please annotate it with @Indexed and make sure at least one field has some indexing annotation, or remove it from the configuration.")
    public CacheConfigurationException typeNotIndexed(String var1);

    @Message(id=28022, value="The declared indexed type '%s' is not known. Please register its proto schema file first")
    public CacheConfigurationException unknownType(String var1);
}

