/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.EncryptionConfiguration;
import org.infinispan.server.core.configuration.SniConfiguration;
import org.infinispan.server.core.configuration.SniConfigurationBuilder;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;

public class EncryptionConfigurationBuilder
implements Builder<EncryptionConfiguration> {
    private final AttributeSet attributes;
    private final List<SniConfigurationBuilder> sniConfigurations = new ArrayList<SniConfigurationBuilder>();
    private final SslConfigurationBuilder ssl;

    public EncryptionConfigurationBuilder(SslConfigurationBuilder sslConfigurationBuilder) {
        this.ssl = sslConfigurationBuilder;
        this.attributes = EncryptionConfiguration.attributeDefinitionSet();
    }

    public SniConfigurationBuilder addSni() {
        SniConfigurationBuilder sni = new SniConfigurationBuilder(this.ssl);
        this.sniConfigurations.add(sni);
        return sni;
    }

    public EncryptionConfigurationBuilder sslContext(SSLContext context) {
        this.ssl.sslContext(context);
        return this;
    }

    public EncryptionConfigurationBuilder sslContext(Supplier<SSLContext> context) {
        this.ssl.sslContext(context);
        return this;
    }

    public EncryptionConfigurationBuilder realm(String name) {
        this.ssl.enable();
        this.attributes.attribute(EncryptionConfiguration.SECURITY_REALM).set((Object)name);
        return this;
    }

    public EncryptionConfigurationBuilder requireClientAuth(boolean require) {
        this.attributes.attribute(EncryptionConfiguration.REQUIRE_CLIENT_AUTH).set((Object)require);
        this.ssl.requireClientAuth(require);
        return this;
    }

    public EncryptionConfiguration create() {
        List<SniConfiguration> snis = this.sniConfigurations.stream().map(SniConfigurationBuilder::create).collect(Collectors.toList());
        return new EncryptionConfiguration(this.attributes.protect(), snis);
    }

    public EncryptionConfigurationBuilder read(EncryptionConfiguration template) {
        this.attributes.read(template.attributes());
        this.sniConfigurations.clear();
        template.sniConfigurations().forEach(s -> this.addSni().read((SniConfiguration)((Object)s)));
        return this;
    }
}

