/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Objects;

public class InetAddressPrincipal
implements Principal {
    private final InetAddress address;

    public InetAddressPrincipal(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        try {
            this.address = InetAddress.getByAddress(address.getHostAddress(), address.getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getName() {
        return this.address.getHostAddress();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetAddressPrincipal that = (InetAddressPrincipal)o;
        return Objects.equals(this.address, that.address);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.address);
    }

    @Override
    public String toString() {
        return "InetAddressPrincipal [address=" + this.address + "]";
    }
}

