/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public class SslEngineConfiguration {
    private final String keyStoreFileName;
    private final String keyStoreType;
    private final char[] keyStorePassword;
    private final String keyAlias;
    private final String protocol;
    private final Supplier<SSLContext> sslContext;
    private final String trustStoreFileName;
    private final String trustStoreType;
    private final char[] trustStorePassword;
    private final char[] keyStoreCertificatePassword;

    SslEngineConfiguration(String keyStoreFileName, String keyStoreType, char[] keyStorePassword, char[] keyStoreCertificatePassword, String keyAlias, Supplier<SSLContext> sslContext, String trustStoreFileName, String trustStoreType, char[] trustStorePassword, String protocol) {
        this.keyStoreFileName = keyStoreFileName;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreCertificatePassword = keyStoreCertificatePassword;
        this.keyAlias = keyAlias;
        this.sslContext = sslContext;
        this.trustStoreFileName = trustStoreFileName;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = trustStorePassword;
        this.protocol = protocol;
    }

    public String keyStoreFileName() {
        return this.keyStoreFileName;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public char[] keyStorePassword() {
        return this.keyStorePassword;
    }

    public char[] keyStoreCertificatePassword() {
        return this.keyStoreCertificatePassword;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public SSLContext sslContext() {
        return this.sslContext == null ? null : this.sslContext.get();
    }

    Supplier<SSLContext> sslContextSupplier() {
        return this.sslContext;
    }

    public String trustStoreFileName() {
        return this.trustStoreFileName;
    }

    public String trustStoreType() {
        return this.trustStoreType;
    }

    public char[] trustStorePassword() {
        return this.trustStorePassword;
    }

    public String protocol() {
        return this.protocol;
    }

    public String[] protocols() {
        if (this.protocol != null) {
            return new String[]{this.protocol};
        }
        return null;
    }

    public String toString() {
        return "SslEngineConfiguration{keyStoreFileName='" + this.keyStoreFileName + "', keyStoreType='" + this.keyStoreType + "', keyAlias='" + this.keyAlias + "', protocol='" + this.protocol + "', sslContext=" + String.valueOf(this.sslContext) + ", trustStoreFileName='" + this.trustStoreFileName + "', trustStoreType='" + this.trustStoreType + "'}";
    }
}

