/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.factories;

import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.factories.threads.NonBlockingThreadFactory;
import org.infinispan.factories.threads.NonBlockingThreadPoolExecutorFactory;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.NonRecursiveEventLoopGroup;

@DefaultFactoryFor(classes={EventLoopGroup.class})
public class NettyEventLoopFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        ThreadPoolExecutorFactory tpef;
        ThreadFactory threadFactory = this.globalConfiguration.nonBlockingThreadPool().threadFactory();
        if (threadFactory == null) {
            threadFactory = new NonBlockingThreadFactory("ISPN-non-blocking-thread-group", KnownComponentNames.getDefaultThreadPrio((String)"org.infinispan.executors.non-blocking"), "%c-%n-p%f-t%t", this.globalConfiguration.transport().nodeName(), KnownComponentNames.shortened((String)"org.infinispan.executors.non-blocking"));
        }
        if (threadFactory instanceof DefaultThreadFactory) {
            ((DefaultThreadFactory)threadFactory).useVirtualThread(false);
        }
        int threadAmount = (tpef = this.globalConfiguration.nonBlockingThreadPool().threadPoolFactory()) instanceof NonBlockingThreadPoolExecutorFactory ? ((NonBlockingThreadPoolExecutorFactory)tpef).maxThreads() : KnownComponentNames.getDefaultThreads((String)"org.infinispan.executors.non-blocking");
        return new NonRecursiveEventLoopGroup(NettyTransport.buildEventLoop(threadAmount, threadFactory, "non-blocking-thread-netty"));
    }
}

