/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.operation;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.security.auth.Subject;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.command.tx.ForwardCommitCommand;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.operation.BaseCompleteTransactionOperation;
import org.infinispan.server.hotrod.tx.operation.Util;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.logging.LogFactory;

public class CommitTransactionOperation
extends BaseCompleteTransactionOperation<TransactionBoundaryCommand, ForwardCommitCommand> {
    private static final Log log = (Log)LogFactory.getLog(CommitTransactionOperation.class, Log.class);
    private final BiFunction<?, Throwable, Void> handler = (ignored, throwable) -> {
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Handle response: value=%s, throwable=%s", this.xid, ignored, throwable);
        }
        if (throwable != null) {
            while (throwable != null) {
                if (throwable instanceof HeuristicCommitException) {
                    this.hasCommits = true;
                    return null;
                }
                if (throwable instanceof HeuristicMixedException) {
                    this.hasCommits = true;
                    this.hasRollbacks = true;
                    return null;
                }
                if (throwable instanceof HeuristicRollbackException || throwable instanceof RollbackException) {
                    this.hasRollbacks = true;
                    return null;
                }
                throwable = throwable.getCause();
            }
            this.hasErrors = true;
        } else {
            this.hasCommits = true;
        }
        return null;
    };

    public CommitTransactionOperation(HotRodHeader header, HotRodServer server, Subject subject, XidImpl xid, BiConsumer<HotRodHeader, Integer> reply) {
        super(header, server, subject, xid, reply);
    }

    @Override
    public void run() {
        this.globalTxTable.markToCommit(this.xid, this);
    }

    @Override
    public void addCache(ByteString cacheName, Status status) {
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Collected cache %s status %s", this.xid, cacheName, (Object)status);
        }
        switch (status) {
            case MARK_ROLLBACK: 
            case ROLLED_BACK: {
                this.hasRollbacks = true;
                break;
            }
            case COMMITTED: {
                this.hasCommits = true;
                break;
            }
            case ERROR: {
                this.hasErrors = true;
                break;
            }
            case NO_TRANSACTION: 
            case PREPARING: 
            case ACTIVE: 
            case PREPARED: {
                this.hasErrors = true;
                break;
            }
            default: {
                this.cacheNames.add(cacheName);
            }
        }
        this.notifyCacheCollected();
    }

    @Override
    <T> BiFunction<T, Throwable, Void> handler() {
        return this.handler;
    }

    @Override
    void sendReply() {
        int xaCode = 0;
        if (this.hasErrors) {
            xaCode = -3;
        } else if (this.hasCommits && this.hasRollbacks) {
            xaCode = 5;
        } else if (this.hasRollbacks) {
            xaCode = 6;
        }
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Sending reply %s", this.xid, xaCode);
        }
        this.reply.accept(this.header, xaCode);
    }

    @Override
    TransactionBoundaryCommand buildRemoteCommand(Configuration configuration, CommandsFactory commandsFactory, TxState state) {
        if (configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC) {
            return commandsFactory.buildPrepareCommand(state.getGlobalTransaction(), state.getModifications(), true);
        }
        if (Configurations.isTxVersioned((Configuration)configuration)) {
            return commandsFactory.buildVersionedCommitCommand(state.getGlobalTransaction());
        }
        return commandsFactory.buildCommitCommand(state.getGlobalTransaction());
    }

    @Override
    ForwardCommitCommand buildForwardCommand(ByteString cacheName, long timeout) {
        return new ForwardCommitCommand(cacheName, this.xid, timeout);
    }

    @Override
    void asyncCompleteLocalTransaction(AdvancedCache<?, ?> cache, long timeout, AggregateCompletionStage<Void> stageCollector) {
        stageCollector.dependsOn(this.blockingManager.runBlocking(() -> {
            try {
                Util.commitLocalTransaction(cache, this.xid, timeout);
            }
            catch (HeuristicMixedException e) {
                this.hasCommits = true;
                this.hasRollbacks = true;
            }
            catch (HeuristicRollbackException | RollbackException e) {
                this.hasRollbacks = true;
            }
            catch (Throwable t) {
                this.hasErrors = true;
            }
        }, (Object)this));
    }
}

