/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.util.concurrent.CompletionStages;

public abstract class RespRequestHandler {
    protected final CompletionStage<RespRequestHandler> myStage = CompletableFuture.completedFuture(this);
    public static final AttributeKey<ByteBufPool> BYTE_BUF_POOL_ATTRIBUTE_KEY = AttributeKey.newInstance((String)"buffer-pool");
    ByteBufPool allocatorToUse;
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    protected void initializeIfNecessary(ChannelHandlerContext ctx) {
        if (this.allocatorToUse == null) {
            if (!ctx.channel().hasAttr(BYTE_BUF_POOL_ATTRIBUTE_KEY)) {
                throw new IllegalStateException("BufferPool was not initialized in the context " + ctx);
            }
            this.allocatorToUse = (ByteBufPool)ctx.channel().attr(BYTE_BUF_POOL_ATTRIBUTE_KEY).get();
        }
    }

    public final CompletionStage<RespRequestHandler> handleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
        this.initializeIfNecessary(ctx);
        if (type == null) {
            RespRequestHandler.stringToByteBuf("-ERR unknown command\r\n", this.allocatorToUse);
            return this.myStage;
        }
        return this.actualHandleRequest(ctx, type, arguments);
    }

    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
        if (type == RespCommand.QUIT) {
            ctx.close();
            return this.myStage;
        }
        RespRequestHandler.stringToByteBuf("-ERR unknown command\r\n", this.allocatorToUse);
        return this.myStage;
    }

    public void handleChannelDisconnect(ChannelHandlerContext ctx) {
    }

    protected <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, BiConsumer<? super E, ByteBufPool> biConsumer) {
        return this.stageToReturn(stage, ctx, Objects.requireNonNull(biConsumer), null);
    }

    protected <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, Function<E, RespRequestHandler> handlerWhenComplete) {
        return this.stageToReturn(stage, ctx, null, Objects.requireNonNull(handlerWhenComplete));
    }

    private <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, BiConsumer<? super E, ByteBufPool> biConsumer, Function<E, RespRequestHandler> handlerWhenComplete) {
        assert (ctx.channel().eventLoop().inEventLoop());
        assert (biConsumer != null && handlerWhenComplete == null || biConsumer == null && handlerWhenComplete != null) : "triConsumer was: " + biConsumer + " and handlerWhenComplete was: " + handlerWhenComplete;
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            Object result = CompletionStages.join(stage);
            try {
                if (handlerWhenComplete != null) {
                    return CompletableFuture.completedFuture(handlerWhenComplete.apply(result));
                }
                biConsumer.accept(result, this.allocatorToUse);
            }
            catch (Throwable t2) {
                return CompletableFutures.completedExceptionFuture((Throwable)t2);
            }
            return this.myStage;
        }
        if (biConsumer != null) {
            return CompletionStages.handleAndComposeAsync(stage, (e, t) -> {
                if (t != null) {
                    Resp3Handler.handleThrowable(this.allocatorToUse, t);
                } else {
                    try {
                        biConsumer.accept(e, this.allocatorToUse);
                    }
                    catch (Throwable innerT) {
                        return CompletableFutures.completedExceptionFuture((Throwable)innerT);
                    }
                }
                return this.myStage;
            }, (Executor)ctx.channel().eventLoop());
        }
        return stage.handle((value, t) -> {
            if (t != null) {
                return this;
            }
            return (RespRequestHandler)handlerWhenComplete.apply(value);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuf stringToByteBufWithExtra(CharSequence string, ByteBufPool alloc, int extraBytes) {
        boolean release = true;
        int stringBytes = ByteBufUtil.utf8Bytes((CharSequence)string);
        int allocatedSize = stringBytes + extraBytes;
        ByteBuf buffer = (ByteBuf)alloc.apply(allocatedSize);
        try {
            int beforeWriteIndex = buffer.writerIndex();
            ByteBufUtil.reserveAndWriteUtf8((ByteBuf)buffer, (CharSequence)string, (int)allocatedSize);
            assert (buffer.capacity() - buffer.writerIndex() > extraBytes);
            assert (buffer.writerIndex() - beforeWriteIndex == stringBytes);
            release = false;
        }
        finally {
            if (release) {
                buffer.release();
            }
        }
        return buffer;
    }

    protected static ByteBuf stringToByteBuf(CharSequence string, ByteBufPool alloc) {
        return RespRequestHandler.stringToByteBufWithExtra(string, alloc, 0);
    }

    protected static ByteBuf bytesToResult(byte[] result, ByteBufPool alloc) {
        int length = result.length;
        int stringLength = RespRequestHandler.stringSize(length);
        int exactSize = stringLength + length + 5;
        ByteBuf buffer = alloc.acquire(exactSize);
        buffer.writeByte(36);
        RespRequestHandler.setIntChars(length, stringLength, buffer);
        buffer.writeByte(13).writeByte(10);
        buffer.writeBytes(result);
        buffer.writeByte(13).writeByte(10);
        return buffer;
    }

    protected static int stringSize(int x) {
        int d = 1;
        if (x >= 0) {
            d = 0;
            x = -x;
        }
        int p = -10;
        for (int i = 1; i < 10; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10 * p;
        }
        return 10 + d;
    }

    protected static int setIntChars(int i, int index, ByteBuf buf) {
        int r;
        int q;
        boolean negative;
        int writeIndex = buf.writerIndex();
        int charPos = index;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            q = i / 100;
            r = q * 100 - i;
            i = q;
            buf.setByte(writeIndex + --charPos, (int)DigitOnes[r]);
            buf.setByte(writeIndex + --charPos, (int)DigitTens[r]);
        }
        q = i / 10;
        r = q * 10 - i;
        buf.setByte(writeIndex + --charPos, (int)((byte)(48 + r)));
        if (q < 0) {
            buf.setByte(writeIndex + --charPos, (int)((byte)(48 - q)));
        }
        if (negative) {
            buf.setByte(writeIndex + --charPos, 45);
        }
        buf.writerIndex(writeIndex + index);
        return charPos;
    }
}

