/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization;

import java.util.ArrayList;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.BigNumberSerializer;
import org.infinispan.server.resp.serialization.CollectionSerializer;
import org.infinispan.server.resp.serialization.DoubleSerializer;
import org.infinispan.server.resp.serialization.MapSerializer;
import org.infinispan.server.resp.serialization.NestedResponseSerializer;
import org.infinispan.server.resp.serialization.PrimitiveSerializer;
import org.infinispan.server.resp.serialization.ResponseSerializer;
import org.infinispan.server.resp.serialization.SerializationHint;
import org.infinispan.server.resp.serialization.ThrowableSerializer;

public final class Resp3SerializerRegistry {
    private static final ResponseSerializer<?>[] serializers;

    private Resp3SerializerRegistry() {
    }

    static void serialize(Object value, ByteBufPool alloc) {
        Resp3SerializerRegistry.serialize(value, alloc, serializers);
    }

    static void serialize(Object value, ByteBufPool alloc, ResponseSerializer<?>[] candidates) {
        if (PrimitiveSerializer.NullSerializer.INSTANCE.test(value)) {
            PrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, alloc);
            return;
        }
        for (ResponseSerializer<?> serializer : candidates) {
            if (!serializer.test(value)) continue;
            Resp3SerializerRegistry.serialize(serializer, value, alloc);
            return;
        }
        throw new IllegalStateException("Serializer unknown: " + String.valueOf(value.getClass()));
    }

    static void serialize(Object value, ByteBufPool alloc, ResponseSerializer<?> candidate) {
        if (PrimitiveSerializer.NullSerializer.INSTANCE.test(value)) {
            PrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, alloc);
            return;
        }
        if (!candidate.test(value)) {
            throw new IllegalStateException("Serializer not handling: " + String.valueOf(value.getClass()));
        }
        Resp3SerializerRegistry.serialize(candidate, value, alloc);
    }

    static <H extends SerializationHint> void serialize(Object value, ByteBufPool alloc, NestedResponseSerializer<?, H> candidate, H hint) {
        if (PrimitiveSerializer.NullSerializer.INSTANCE.test(value)) {
            PrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, alloc);
            return;
        }
        if (!candidate.test(value)) {
            throw new IllegalStateException("Serializer not handling: " + String.valueOf(value.getClass()));
        }
        NestedResponseSerializer<?, H> nrs = candidate;
        nrs.accept(value, alloc, hint);
    }

    private static void serialize(ResponseSerializer<?> serializer, Object value, ByteBufPool alloc) {
        ResponseSerializer<?> s = serializer;
        s.accept(value, alloc);
    }

    static {
        ArrayList s = new ArrayList(PrimitiveSerializer.SERIALIZERS);
        s.add(CollectionSerializer.ArraySerializer.INSTANCE);
        s.add(CollectionSerializer.SetSerializer.INSTANCE);
        s.add(DoubleSerializer.INSTANCE);
        s.add(ThrowableSerializer.INSTANCE);
        s.add(MapSerializer.INSTANCE);
        s.add(BigNumberSerializer.INSTANCE);
        serializers = (ResponseSerializer[])s.toArray(ResponseSerializer[]::new);
    }
}

