/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.commands.connection.QUIT;

public abstract class RespRequestHandler {
    protected final CompletionStage<RespRequestHandler> myStage = CompletableFuture.completedFuture(this);
    protected final RespServer respServer;
    public static final AttributeKey<ByteBufPool> BYTE_BUF_POOL_ATTRIBUTE_KEY = AttributeKey.newInstance((String)"buffer-pool");
    private final BiFunction<RespRequestHandler, Throwable, RespRequestHandler> HANDLE_FAILURE = (h, t) -> {
        if (t != null) {
            Resp3Handler.handleThrowable(this.allocator(), t);
            return this;
        }
        return h;
    };
    ByteBufPool allocatorToUse;
    ChannelHandlerContext ctx;

    protected RespRequestHandler(RespServer server) {
        this.respServer = server;
    }

    protected void initializeIfNecessary(ChannelHandlerContext ctx) {
        if (this.allocatorToUse == null) {
            if (!ctx.channel().hasAttr(BYTE_BUF_POOL_ATTRIBUTE_KEY)) {
                throw new IllegalStateException("BufferPool was not initialized in the context " + String.valueOf(ctx));
            }
            this.allocatorToUse = (ByteBufPool)ctx.channel().attr(BYTE_BUF_POOL_ATTRIBUTE_KEY).get();
            this.ctx = ctx;
        }
    }

    public RespServer respServer() {
        return this.respServer;
    }

    public CompletionStage<RespRequestHandler> myStage() {
        return this.myStage;
    }

    public ByteBufPool allocator() {
        assert (this.ctx.channel().eventLoop().inEventLoop()) : "Buffer allocation should occur in event loop, it was " + Thread.currentThread().getName();
        return this.allocatorToUse;
    }

    public final CompletionStage<RespRequestHandler> handleRequest(ChannelHandlerContext ctx, RespCommand command, List<byte[]> arguments) {
        this.initializeIfNecessary(ctx);
        if (command == null) {
            RespErrorUtil.unknownCommand(this.allocatorToUse);
            return this.myStage;
        }
        if (!command.hasValidNumberOfArguments(arguments)) {
            RespErrorUtil.wrongArgumentNumber(command, this.allocator());
            return this.myStage;
        }
        try {
            return this.actualHandleRequest(ctx, command, arguments);
        }
        catch (Exception e) {
            Consumer<ByteBufPool> writer = RespErrorUtil.handleException(e);
            if (writer == null) {
                return CompletableFuture.failedFuture(e);
            }
            writer.accept(this.allocatorToUse);
            return this.myStage();
        }
    }

    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
        if (type instanceof QUIT) {
            ctx.close();
            return this.myStage;
        }
        RespErrorUtil.unknownCommand(this.allocatorToUse);
        return this.myStage;
    }

    public void handleChannelDisconnect(ChannelHandlerContext ctx) {
    }

    public <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, BiConsumer<? super E, ByteBufPool> biConsumer) {
        return this.stageToReturn(stage, ctx, Objects.requireNonNull(biConsumer), null);
    }

    public <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, Function<E, RespRequestHandler> handlerWhenComplete) {
        return this.stageToReturn(stage, ctx, null, Objects.requireNonNull(handlerWhenComplete));
    }

    public CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<RespRequestHandler> stage, ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            RespRequestHandler rrh = (RespRequestHandler)CompletionStages.join(stage);
            return rrh.myStage();
        }
        return stage.handleAsync(this.HANDLE_FAILURE, (Executor)ctx.channel().eventLoop());
    }

    private <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, BiConsumer<? super E, ByteBufPool> biConsumer, Function<E, RespRequestHandler> handlerWhenComplete) {
        assert (ctx.channel().eventLoop().inEventLoop());
        assert (biConsumer != null && handlerWhenComplete == null || biConsumer == null && handlerWhenComplete != null) : "triConsumer was: " + String.valueOf(biConsumer) + " and handlerWhenComplete was: " + String.valueOf(handlerWhenComplete);
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            Object result = CompletionStages.join(stage);
            try {
                if (handlerWhenComplete != null) {
                    return CompletableFuture.completedFuture(handlerWhenComplete.apply(result));
                }
                biConsumer.accept(result, this.allocatorToUse);
            }
            catch (Throwable t2) {
                Resp3Handler.handleThrowable(this.allocatorToUse, t2);
                return this.myStage();
            }
            return this.myStage;
        }
        if (biConsumer != null) {
            return CompletionStages.handleAndComposeAsync(stage, (e, t) -> {
                if (t != null) {
                    Resp3Handler.handleThrowable(this.allocatorToUse, t);
                } else {
                    try {
                        biConsumer.accept(e, this.allocatorToUse);
                    }
                    catch (Throwable innerT) {
                        return CompletableFuture.failedFuture(innerT);
                    }
                }
                return this.myStage;
            }, (Executor)ctx.channel().eventLoop());
        }
        return stage.handleAsync((value, t) -> {
            if (t != null) {
                Resp3Handler.handleThrowable(this.allocatorToUse, t);
                return this;
            }
            return (RespRequestHandler)handlerWhenComplete.apply(value);
        }, (Executor)ctx.channel().eventLoop());
    }
}

