/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.hash;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;

public class HINCRBY
extends RespCommand
implements Resp3Command {
    private static final BiConsumer<byte[], ByteBufPool> CONVERTER = (value, pool) -> Consumers.LONG_BICONSUMER.accept(ArgumentUtils.toLong(value), (ByteBufPool)pool);

    public HINCRBY() {
        super(4, 1, 1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedMultimapPairCache<byte[], byte[], byte[]> multimap = handler.getHashMapMultimap();
        long delta = ArgumentUtils.toLong(arguments.get(2));
        AtomicBoolean failed = new AtomicBoolean(false);
        CompletionStage cs = multimap.compute((Object)arguments.get(0), (Object)arguments.get(1), (ignore, prev) -> {
            long result;
            if (prev == null) {
                return (byte[])arguments.get(2);
            }
            long prevLong = ArgumentUtils.toLong(prev);
            if (((prevLong ^ (result = prevLong + delta)) & (delta ^ result)) < 0L) {
                failed.set(true);
                return prev;
            }
            return ArgumentUtils.toByteArray(result);
        });
        return handler.stageToReturn(cs, ctx, (res, alloc) -> {
            if (failed.get()) {
                RespErrorUtil.customError("increment or decrement would overflow", alloc);
            } else {
                CONVERTER.accept((byte[])res, (ByteBufPool)alloc);
            }
        });
    }
}

