/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.prometheus.client.exporter.common.TextFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.infinispan.commons.util.Util;
import org.infinispan.metrics.impl.MetricsCollector;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;

public final class MetricsResource
implements ResourceHandler {
    private static final String METRICS_PATH = "/metrics";
    private final boolean auth;
    private final Executor blockingExecutor;
    private final MetricsCollector metricsCollector;
    private final InvocationHelper invocationHelper;

    public MetricsResource(boolean auth, InvocationHelper invocationHelper) {
        this.auth = auth;
        this.blockingExecutor = invocationHelper.getExecutor();
        this.metricsCollector = invocationHelper.getMetricsCollector();
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET, Method.OPTIONS).path(METRICS_PATH).anonymous(!this.auth).handleWith(this::metrics).invocation().methods(Method.GET, Method.OPTIONS).path("/metrics/*").anonymous(!this.auth).handleWith(this::metrics).create();
    }

    private CompletionStage<RestResponse> metrics(RestRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
            try {
                PrometheusMeterRegistry registry = this.metricsCollector.registry();
                if (registry == null) {
                    return ((NettyRestResponse.Builder)builder.status(HttpResponseStatus.NOT_FOUND.code())).build();
                }
                String contentType = TextFormat.chooseContentType((String)request.getAcceptHeader());
                builder.header("Content-Type", contentType);
                builder.entity(registry.scrape(contentType));
                return builder.build();
            }
            catch (Exception e) {
                throw Util.unchecked((Throwable)e);
            }
        }, this.blockingExecutor);
    }
}

