/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.routes.hotrod;

import io.netty.handler.ssl.SslContext;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.router.router.impl.hotrod.handlers.util.SslUtils;
import org.infinispan.server.router.routes.SniRouteSource;

public class SniNettyRouteSource
implements SniRouteSource {
    private final SslContext nettyContext;
    private final SSLContext jdkContext;
    private final String sniHostName;

    public SniNettyRouteSource(String sniHostName, SSLContext sslContext) {
        this.sniHostName = sniHostName;
        this.jdkContext = sslContext;
        this.nettyContext = SslUtils.INSTANCE.toNettySslContext(Optional.ofNullable(this.jdkContext));
    }

    public SniNettyRouteSource(String sniHostName, String keyStoreFileName, char[] keyStorePassword) {
        this(sniHostName, new SslContextFactory().keyStoreFileName(keyStoreFileName).keyStorePassword(keyStorePassword).getContext());
    }

    @Override
    public SSLContext getSslContext() {
        return this.jdkContext;
    }

    @Override
    public String getSniHostName() {
        return this.sniHostName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SniNettyRouteSource that = (SniNettyRouteSource)o;
        return this.getSniHostName().equals(that.getSniHostName());
    }

    public int hashCode() {
        return this.getSniHostName().hashCode();
    }

    public String toString() {
        return "SniNettyRouteSource{sniHostName='" + this.sniHostName + "'}";
    }

    @Override
    public void validate() {
        if (this.sniHostName == null || "".equals(this.sniHostName)) {
            throw new IllegalArgumentException("SNI Host name can not be null");
        }
        if (this.jdkContext == null) {
            throw new IllegalArgumentException("JDK SSL Context must not be null");
        }
    }
}

