/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.server.configuration.DataSourcesConfigurationBuilder;
import org.infinispan.server.configuration.InterfacesConfiguration;
import org.infinispan.server.configuration.InterfacesConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointsConfigurationBuilder;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.configuration.security.SecurityConfigurationBuilder;

public class ServerConfigurationBuilder
implements Builder<ServerConfiguration> {
    private final Properties properties = new Properties();
    private final InterfacesConfigurationBuilder interfaces = new InterfacesConfigurationBuilder();
    private final SocketBindingsConfigurationBuilder socketBindings = new SocketBindingsConfigurationBuilder(this);
    private final SecurityConfigurationBuilder security = new SecurityConfigurationBuilder(this);
    private final DataSourcesConfigurationBuilder dataSources = new DataSourcesConfigurationBuilder();
    private final EndpointsConfigurationBuilder endpoints = new EndpointsConfigurationBuilder(this);
    private final List<SSLContextSupplier> suppliers = new ArrayList<SSLContextSupplier>();

    public ServerConfigurationBuilder(GlobalConfigurationBuilder builder) {
    }

    public ServerConfigurationBuilder properties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public Properties properties() {
        return this.properties;
    }

    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    public InterfacesConfigurationBuilder interfaces() {
        return this.interfaces;
    }

    public SocketBindingsConfigurationBuilder socketBindings() {
        return this.socketBindings;
    }

    public DataSourcesConfigurationBuilder dataSources() {
        return this.dataSources;
    }

    public EndpointsConfigurationBuilder endpoints() {
        return this.endpoints;
    }

    public void validate() {
        Arrays.asList(this.interfaces, this.socketBindings, this.security, this.endpoints).forEach(Builder::validate);
    }

    public ServerConfiguration create() {
        SecurityConfiguration securityConfiguration = this.security.create();
        for (SSLContextSupplier supplier : this.suppliers) {
            supplier.configuration = securityConfiguration;
        }
        InterfacesConfiguration interfacesConfiguration = this.interfaces.create();
        SocketBindingsConfiguration bindingsConfiguration = this.socketBindings.create(interfacesConfiguration);
        return new ServerConfiguration(interfacesConfiguration, bindingsConfiguration, securityConfiguration, this.dataSources.create(), this.endpoints.create(bindingsConfiguration, securityConfiguration));
    }

    public Builder<?> read(ServerConfiguration template) {
        return this;
    }

    public Supplier<SSLContext> serverSSLContextSupplier(String sslContextName) {
        SSLContextSupplier supplier = new SSLContextSupplier(sslContextName, false);
        this.suppliers.add(supplier);
        return supplier;
    }

    public Supplier<SSLContext> clientSSLContextSupplier(String sslContextName) {
        SSLContextSupplier supplier = new SSLContextSupplier(sslContextName, true);
        this.suppliers.add(supplier);
        return supplier;
    }

    private static class SSLContextSupplier
    implements Supplier<SSLContext> {
        final String name;
        final boolean client;
        SecurityConfiguration configuration;

        SSLContextSupplier(String name, boolean client) {
            this.name = name;
            this.client = client;
        }

        @Override
        public SSLContext get() {
            return this.client ? this.configuration.realms().getRealm(this.name).clientSSLContext() : this.configuration.realms().getRealm(this.name).serverSSLContext();
        }
    }
}

