/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;

public class LdapAttributeConfiguration
extends ConfigurationElement<LdapAttributeConfiguration> {
    static final AttributeDefinition<String> FILTER = AttributeDefinition.builder((Enum)Attribute.FILTER, null, String.class).build();
    static final AttributeDefinition<String> FILTER_DN = AttributeDefinition.builder((Enum)Attribute.FILTER_DN, null, String.class).build();
    static final AttributeDefinition<String> FROM = AttributeDefinition.builder((Enum)Attribute.FROM, null, String.class).build();
    static final AttributeDefinition<String> TO = AttributeDefinition.builder((Enum)Attribute.TO, null, String.class).build();
    static final AttributeDefinition<String> REFERENCE = AttributeDefinition.builder((Enum)Attribute.REFERENCE, null, String.class).build();
    static final AttributeDefinition<Boolean> SEARCH_RECURSIVE = AttributeDefinition.builder((Enum)Attribute.SEARCH_RECURSIVE, (Object)true, Boolean.class).build();
    static final AttributeDefinition<Integer> ROLE_RECURSION = AttributeDefinition.builder((Enum)Attribute.ROLE_RECURSION, (Object)0, Integer.class).build();
    static final AttributeDefinition<String> ROLE_RECURSION_NAME = AttributeDefinition.builder((Enum)Attribute.ROLE_RECURSION_NAME, (Object)"cn", String.class).build();
    static final AttributeDefinition<String> EXTRACT_RDN = AttributeDefinition.builder((Enum)Attribute.EXTRACT_RDN, null, String.class).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LdapAttributeConfiguration.class, new AttributeDefinition[]{FILTER, FILTER_DN, FROM, TO, REFERENCE, SEARCH_RECURSIVE, ROLE_RECURSION, ROLE_RECURSION_NAME, EXTRACT_RDN});
    }

    LdapAttributeConfiguration(AttributeSet attributes) {
        super((Enum)(attributes.attribute(REFERENCE).isModified() ? Element.ATTRIBUTE_REFERENCE : Element.ATTRIBUTE), attributes, new ConfigurationElement[0]);
    }

    public void build(LdapSecurityRealmBuilder.IdentityMappingBuilder identity) {
        AttributeMapping.Builder builder = this.attributes.attribute(REFERENCE).isModified() ? AttributeMapping.fromReference((String)((String)this.attributes.attribute(REFERENCE).get())) : AttributeMapping.fromFilter((String)((String)this.attributes.attribute(FILTER).get()));
        this.attributes.attribute(FILTER_DN).apply(v -> builder.searchDn(v));
        this.attributes.attribute(FROM).apply(v -> builder.from(v));
        this.attributes.attribute(TO).apply(v -> builder.to(v));
        this.attributes.attribute(SEARCH_RECURSIVE).apply(v -> builder.searchRecursively(v.booleanValue()));
        this.attributes.attribute(ROLE_RECURSION).apply(v -> builder.roleRecursion(v.intValue()));
        this.attributes.attribute(ROLE_RECURSION_NAME).apply(v -> builder.roleRecursionName(v));
        this.attributes.attribute(EXTRACT_RDN).apply(v -> builder.extractRdn(v));
        identity.map(new AttributeMapping[]{builder.build()});
    }
}

