/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.security.Security;

class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    public static Provider[] discoverSecurityProviders(ClassLoader classLoader) {
        return SecurityActions.doPrivileged(() -> SslContextFactory.discoverSecurityProviders((ClassLoader)classLoader));
    }
}

