/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.state;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.impl.Authorizer;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static void checkPermission(EmbeddedCacheManager cacheManager, AuthorizationPermission permission) {
        Authorizer authorizer = (Authorizer)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(Authorizer.class);
        authorizer.checkPermission(cacheManager.getSubject(), permission);
    }
}

