/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.EnumSet;
import java.util.Properties;
import org.infinispan.server.configuration.security.KeyStoreConfiguration;
import org.infinispan.server.configuration.security.SSLEngineConfiguration;
import org.infinispan.server.configuration.security.TrustStoreConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.ssl.SSLContextBuilder;

public class SSLConfiguration {
    private final KeyStoreConfiguration keyStore;
    private final TrustStoreConfiguration trustStore;
    private final SSLEngineConfiguration engine;

    SSLConfiguration(KeyStoreConfiguration keyStore, TrustStoreConfiguration trustStore, SSLEngineConfiguration engine) {
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.engine = engine;
    }

    public KeyStoreConfiguration keyStore() {
        return this.keyStore;
    }

    public TrustStoreConfiguration trustStore() {
        return this.trustStore;
    }

    public SSLEngineConfiguration engine() {
        return this.engine;
    }

    SSLContextBuilder build(Properties properties, EnumSet<ServerSecurityRealm.Feature> features) {
        SSLContextBuilder builder = new SSLContextBuilder().setWrap(false);
        this.keyStore.build(builder, properties, features);
        this.trustStore.build(builder, properties);
        this.engine.build(builder);
        return builder;
    }
}

