/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.security.Provider;
import java.security.Security;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;

final class SecurityActions {
    SecurityActions() {
    }

    static void addSecurityProvider(Provider provider) {
        if (Security.getProvider(provider.getName()) == null) {
            Security.insertProviderAt(provider, 1);
        }
    }

    static void startCacheManager(EmbeddedCacheManager cacheManager) {
        Runnable action = () -> cacheManager.start();
        org.infinispan.security.Security.doPrivileged((Runnable)action);
    }

    static boolean stopCacheManager(EmbeddedCacheManager cacheManager) {
        Supplier<Boolean> action = () -> {
            if (cacheManager != null) {
                cacheManager.stop();
                return true;
            }
            return false;
        };
        return (Boolean)org.infinispan.security.Security.doPrivileged(action);
    }

    static void startProtocolServer(ProtocolServer<ProtocolServerConfiguration> server, ProtocolServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        org.infinispan.security.Security.doPrivileged(() -> {
            server.start(configuration, cacheManager);
            return null;
        });
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager manager) {
        return org.infinispan.security.actions.SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)manager);
    }

    static void shutdownAllCaches(DefaultCacheManager manager) {
        Runnable action = () -> manager.shutdownAllCaches();
        org.infinispan.security.Security.doPrivileged((Runnable)action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return org.infinispan.security.actions.SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager);
    }

    static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder initialContextFactoryBuilder) throws NamingException {
        NamingManager.setInitialContextFactoryBuilder(initialContextFactoryBuilder);
    }

    static void checkPermission(EmbeddedCacheManager cacheManager, AuthorizationPermission permission) {
        Authorizer authorizer = (Authorizer)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(Authorizer.class);
        authorizer.checkPermission(cacheManager.getSubject(), permission);
    }

    static ClusterExecutor getClusterExecutor(EmbeddedCacheManager cacheManager) {
        return (ClusterExecutor)org.infinispan.security.Security.doPrivileged(() -> cacheManager.executor());
    }
}

