/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.security.auth.x500.X500Principal;
import org.infinispan.cli.user.UserTool;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.maven.Artifact;
import org.infinispan.commons.maven.MavenSettings;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.junit.Assume;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.SubjectAlternativeNamesExtension;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public abstract class AbstractInfinispanServerDriver
implements InfinispanServerDriver {
    public static final String DEFAULT_CLUSTERED_INFINISPAN_CONFIG_FILE_NAME = "infinispan.xml";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String INFINISPAN_CLUSTER_NAME = "infinispan.cluster.name";
    public static final String INFINISPAN_CLUSTER_STACK = "infinispan.cluster.stack";
    public static final String INFINISPAN_SERVER_CONFIG_PATH = "infinispan.server.config.path";
    public static final String TEST_HOST_ADDRESS = "org.infinispan.test.host.address";
    public static final String JOIN_TIMEOUT = "jgroups.join_timeout";
    public static final String BASE_DN = "CN=%s,OU=Infinispan,O=JBoss,L=Red Hat";
    public static final String KEY_PASSWORD = "secret";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String DEFAULT_SERVER_CONFIG = "conf";
    public static final String DEFAULT_SERVER_DATA = "data";
    public static final String DEFAULT_SERVER_LIB = "lib";
    public static final String DEFAULT_SERVER_LOG = "log";
    protected final InfinispanServerTestConfiguration configuration;
    protected final InetAddress testHostAddress;
    private File rootDir;
    private File confDir;
    private ComponentStatus status;
    private final AtomicLong certSerial = new AtomicLong(1L);
    private String name;
    private final Provider[] ALL_PROVIDERS;

    protected AbstractInfinispanServerDriver(InfinispanServerTestConfiguration configuration, InetAddress testHostAddress) {
        this.configuration = configuration;
        this.testHostAddress = testHostAddress;
        this.status = ComponentStatus.INSTANTIATED;
        this.ALL_PROVIDERS = SslContextFactory.discoverSecurityProviders((ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    public ComponentStatus getStatus() {
        return this.status;
    }

    @Override
    public InfinispanServerTestConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract void start(String var1, File var2, File var3);

    protected String debugJvmOption() {
        String nonLoopbackAddress;
        try {
            nonLoopbackAddress = NetworkAddress.nonLoopback((String)"").getAddress().getHostAddress();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not find a non-loopback address");
        }
        return String.format("-agentlib:jdwp=transport=dt_socket,server=n,address=%s:5005", nonLoopbackAddress);
    }

    protected abstract void stop();

    @Override
    public void prepare(String name) {
        this.name = name;
        if (this.configuration.getFeatures() != null) {
            Features features = new Features(this.getClass().getClassLoader());
            for (String feature : this.configuration.getFeatures()) {
                Assume.assumeTrue((String)String.format("%s is disabled", feature), (boolean)features.isAvailable(feature));
            }
        }
        String siteName = this.configuration.site() == null ? "" : this.configuration.site();
        String testDir = CommonsTestingUtil.tmpDirectory((String[])new String[]{siteName + name});
        Util.recursiveFileRemove((String)testDir);
        this.rootDir = new File(testDir);
        this.confDir = new File(this.rootDir, DEFAULT_SERVER_CONFIG);
        if (!this.confDir.mkdirs()) {
            throw new RuntimeException("Failed to create server configuration directory " + String.valueOf(this.confDir));
        }
        if (!this.configuration.isDefaultFile()) {
            this.copyProvidedServerConfigurationFile();
        }
        this.createUserFile("default");
        this.createKeyStores(".pfx", "pkcs12", null);
        if (ProviderUtil.findProvider((Provider[])this.ALL_PROVIDERS, (String)"BC", KeyStore.class, (String)"BCFKS") != null) {
            this.createKeyStores(".bcfks", "BCFKS", "BC");
        }
    }

    @Override
    public void start(String name) {
        this.status = ComponentStatus.INITIALIZING;
        try {
            log.infof("Starting servers %s", (Object)name);
            this.start(name, this.rootDir, new File(this.configuration.configurationFile()));
            log.infof("Started servers %s", (Object)name);
            this.status = ComponentStatus.RUNNING;
        }
        catch (Throwable t) {
            log.errorf(t, "Unable to start server %s", (Object)name);
            this.status = ComponentStatus.FAILED;
            throw t;
        }
    }

    @Override
    public final void stop(String name) {
        if (this.status != ComponentStatus.INSTANTIATED) {
            this.status = ComponentStatus.STOPPING;
            log.infof("Stopping servers %s", (Object)name);
            this.stop();
            log.infof("Stopped servers %s", (Object)name);
        }
        this.status = ComponentStatus.TERMINATED;
    }

    private void copyProvidedServerConfigurationFile() {
        this.copyResource(this.configuration.configurationFile(), this.confDir.toPath());
    }

    private void copyResource(String resource, Path dst) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File configFile = new File(resource);
        if (configFile.isAbsolute()) {
            Path source = Paths.get(configFile.getParentFile().getAbsolutePath(), new String[0]);
            Exceptions.unchecked(() -> Util.recursiveDirectoryCopy((Path)source, (Path)dst));
            return;
        }
        URL resourceUrl = classLoader.getResource(resource);
        if (resourceUrl == null) {
            throw new RuntimeException("Cannot find test file: " + resource);
        }
        Exceptions.unchecked(() -> {
            if (resourceUrl.getProtocol().equals("jar")) {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                String[] parts = resourceUrl.toString().split("!");
                URI jarUri = new URI(parts[0]);
                try (FileSystem fs = FileSystems.newFileSystem(jarUri, env);){
                    String configJarPath = new File(parts[1]).getParentFile().toString();
                    Path source = fs.getPath(configJarPath, new String[0]);
                    Util.recursiveDirectoryCopy((Path)source, (Path)dst);
                }
            } else {
                Path source = Paths.get(resourceUrl.toURI().resolve("."));
                Util.recursiveDirectoryCopy((Path)source, (Path)dst);
            }
        });
    }

    protected static File createServerHierarchy(File baseDir) {
        return AbstractInfinispanServerDriver.createServerHierarchy(baseDir, null);
    }

    protected static File createServerHierarchy(File baseDir, String name) {
        File rootDir = AbstractInfinispanServerDriver.serverRoot(baseDir, name);
        for (String dir : Arrays.asList(DEFAULT_SERVER_DATA, DEFAULT_SERVER_LOG, DEFAULT_SERVER_LIB)) {
            File d = new File(rootDir, dir);
            if (d.exists() || d.mkdirs()) continue;
            throw new IllegalStateException("Unable to create directory " + String.valueOf(d));
        }
        return rootDir;
    }

    protected static File serverRoot(File baseDir, String name) {
        return name == null ? baseDir : new File(baseDir, name);
    }

    protected void createUserFile(String realm) {
        UserTool userTool = new UserTool(this.rootDir.getAbsolutePath());
        for (AuthorizationPermission authorizationPermission : AuthorizationPermission.values()) {
            String name = authorizationPermission.name().toLowerCase();
            userTool.createUser(name + "_user", name, realm, UserTool.Encryption.DEFAULT, Collections.singletonList(name), null);
        }
        for (TestUser testUser : TestUser.values()) {
            if (testUser == TestUser.ANONYMOUS) continue;
            userTool.createUser(testUser.getUser(), testUser.getPassword(), realm, UserTool.Encryption.DEFAULT, testUser.getRoles(), null);
        }
    }

    protected void copyArtifactsToDataDir() {
        if (this.configuration.getDataFiles() == null) {
            return;
        }
        File dataDir = new File(this.rootDir, DEFAULT_SERVER_DATA);
        dataDir.mkdirs();
        for (String file : this.configuration.getDataFiles()) {
            this.copyResource(file, dataDir.toPath());
        }
    }

    protected void copyArtifactsToUserLibDir(File libDir) {
        String[] artifacts;
        String propertyArtifacts = this.configuration.properties().getProperty("org.infinispan.test.server.extension.libs");
        String[] stringArray = artifacts = propertyArtifacts != null ? propertyArtifacts.replaceAll("\\s+", "").split(",") : this.configuration.mavenArtifacts();
        if (artifacts != null && artifacts.length > 0) {
            try {
                MavenSettings.init();
                for (String string : artifacts) {
                    Artifact artifact = Artifact.fromString((String)string);
                    Path resolved = artifact.resolveArtifact();
                    if (resolved == null) {
                        throw new IllegalStateException("Cannot resolve artifact " + String.valueOf(artifact));
                    }
                    Files.copy(resolved, libDir.toPath().resolve(resolved.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.configuration.archives() != null) {
            for (String string : this.configuration.archives()) {
                File jar = libDir.toPath().resolve(string.getName()).toFile();
                jar.setWritable(true, false);
                ((ZipExporter)string.as(ZipExporter.class)).exportTo(jar, true);
            }
        }
    }

    @Override
    public File getCertificateFile(String name) {
        return new File(this.confDir, name);
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public File getConfDir() {
        return this.confDir;
    }

    public String getName() {
        return this.name;
    }

    protected void createKeyStores(String extension, String type, String providerName) {
        try {
            Provider provider = ProviderUtil.findProvider((Provider[])this.ALL_PROVIDERS, (String)providerName, KeyPairGenerator.class, (String)KEY_ALGORITHM);
            KeyPairGenerator keyPairGenerator = provider != null ? KeyPairGenerator.getInstance(KEY_ALGORITHM, provider) : KeyPairGenerator.getInstance(KEY_ALGORITHM);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey signingKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            X500Principal CA_DN = AbstractInfinispanServerDriver.dn("CA");
            provider = ProviderUtil.findProvider((Provider[])this.ALL_PROVIDERS, (String)providerName, KeyStore.class, (String)type);
            KeyStore trustStore = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
            trustStore.load(null, null);
            SelfSignedX509CertificateAndSigningKey ca = this.createSelfSignedCertificate(CA_DN, true, "ca", extension, type, providerName);
            trustStore.setCertificateEntry("ca", ca.getSelfSignedCertificate());
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "server", extension, trustStore);
            for (TestUser user : TestUser.values()) {
                if (user == TestUser.ANONYMOUS) continue;
                this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, user.getUser(), extension, trustStore);
            }
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "supervisor", extension, trustStore);
            try (FileOutputStream os = new FileOutputStream(this.getCertificateFile("trust" + extension));){
                trustStore.store(os, KEY_PASSWORD.toCharArray());
            }
            this.createSelfSignedCertificate(CA_DN, true, "untrusted", extension, type, providerName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static X500Principal dn(String cn) {
        return new X500Principal(String.format(BASE_DN, cn));
    }

    protected SelfSignedX509CertificateAndSigningKey createSelfSignedCertificate(X500Principal dn, boolean isCA, String name, String extension, String type, String providerName) {
        FileWriter w;
        SelfSignedX509CertificateAndSigningKey.Builder certificateBuilder = SelfSignedX509CertificateAndSigningKey.builder().setDn(dn).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setKeyAlgorithmName(KEY_ALGORITHM);
        if (isCA) {
            certificateBuilder.addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647");
        }
        SelfSignedX509CertificateAndSigningKey certificate = certificateBuilder.build();
        X509Certificate issuerCertificate = certificate.getSelfSignedCertificate();
        this.writeKeyStore(this.getCertificateFile(name + extension), type, providerName, ks -> {
            try {
                ks.setCertificateEntry(name, issuerCertificate);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            w = new FileWriter(new File(this.confDir, name + extension + ".crt"));
            try {
                w.write("-----BEGIN CERTIFICATE-----\n");
                w.write(Base64.getEncoder().encodeToString(issuerCertificate.getEncoded()));
                w.write("\n-----END CERTIFICATE-----\n");
            }
            finally {
                w.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            w = new FileWriter(new File(this.confDir, name + extension + ".key"));
            try {
                w.write("-----BEGIN PRIVATE KEY-----\n");
                w.write(Base64.getEncoder().encodeToString(certificate.getSigningKey().getEncoded()));
                w.write("\n-----END PRIVATE KEY-----\n");
            }
            finally {
                w.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return certificate;
    }

    protected void createSignedCertificate(PrivateKey signingKey, PublicKey publicKey, SelfSignedX509CertificateAndSigningKey ca, X500Principal issuerDN, String name, String extension, KeyStore trustStore) throws CertificateException {
        X509Certificate caCertificate = ca.getSelfSignedCertificate();
        X509Certificate certificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(AbstractInfinispanServerDriver.dn(name)).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setSigningKey(ca.getSigningKey()).setPublicKey(publicKey).setSerialNumber(BigInteger.valueOf(this.certSerial.getAndIncrement())).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1)).addExtension((X509CertificateExtension)new SubjectAlternativeNamesExtension(false, List.of(new GeneralName.DNSName("infinispan.test")))).build();
        try {
            trustStore.setCertificateEntry(name, certificate);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        this.writeKeyStore(this.getCertificateFile(name + extension), trustStore.getType(), trustStore.getProvider().getName(), ks -> {
            try {
                ks.setCertificateEntry("ca", caCertificate);
                ks.setKeyEntry(name, signingKey, KEY_PASSWORD.toCharArray(), new X509Certificate[]{certificate, caCertificate});
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void writeKeyStore(File file, String type, String providerName, Consumer<KeyStore> consumer) {
        try (FileOutputStream os = new FileOutputStream(file);){
            Provider provider = ProviderUtil.findProvider((Provider[])this.ALL_PROVIDERS, (String)providerName, KeyStore.class, (String)type);
            KeyStore keyStore = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
            keyStore.load(null, null);
            consumer.accept(keyStore);
            keyStore.store(os, KEY_PASSWORD.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyKeyStore(ConfigurationBuilder builder, String certificateName) {
        this.applyKeyStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyKeyStore(ConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().keyStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).keyStorePassword(KEY_PASSWORD.toCharArray()).keyStoreType(type).provider(provider);
    }

    @Override
    public void applyKeyStore(RestClientConfigurationBuilder builder, String certificateName) {
        this.applyKeyStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyKeyStore(RestClientConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().keyStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).keyStorePassword(KEY_PASSWORD.toCharArray()).keyStoreType(type).provider(provider);
    }

    @Override
    public void applyTrustStore(ConfigurationBuilder builder, String certificateName) {
        this.applyTrustStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyTrustStore(ConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray()).trustStoreType(type).provider(provider);
    }

    @Override
    public void applyTrustStore(RestClientConfigurationBuilder builder, String certificateName) {
        this.applyTrustStore(builder, certificateName, "pkcs12", null);
    }

    @Override
    public void applyTrustStore(RestClientConfigurationBuilder builder, String certificateName, String type, String provider) {
        builder.security().ssl().trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray()).trustStoreType(type).provider(provider);
    }

    @Override
    public void pause(int server) {
    }

    @Override
    public RemoteCacheManager createRemoteCacheManager(ConfigurationBuilder builder) {
        return new RemoteCacheManager(builder.build());
    }

    private static InterfaceAddress findAddress(Predicate<InetAddress> matcher) throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            InterfaceAddress ifAddress;
            NetworkInterface networkInterface = interfaces.nextElement();
            if (!networkInterface.isUp() || (ifAddress = AbstractInfinispanServerDriver.findAddress(networkInterface, matcher)) == null) continue;
            return ifAddress;
        }
        throw new IOException("No matching addresses found");
    }

    private static InterfaceAddress findAddress(NetworkInterface networkInterface, Predicate<InetAddress> matcher) {
        for (InterfaceAddress ifAddress : networkInterface.getInterfaceAddresses()) {
            InetAddress address = ifAddress.getAddress();
            if (!matcher.test(address)) continue;
            return ifAddress;
        }
        return null;
    }

    public static String abbreviate(String name) {
        String[] split = name.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length - 1; ++i) {
            sb.append(split[i].charAt(0));
            sb.append('.');
        }
        sb.append(split[split.length - 1]);
        return sb.toString();
    }
}

