/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import org.jboss.logging.BasicLogger;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public class JBossLoggingConsumer
extends BaseConsumer<JBossLoggingConsumer> {
    private final BasicLogger logger;
    private String prefix = "";

    public JBossLoggingConsumer(BasicLogger logger) {
        this.logger = logger;
    }

    public JBossLoggingConsumer withPrefix(String prefix) {
        this.prefix = "[" + prefix + "] ";
        return this;
    }

    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8String();
        utf8String = utf8String.replaceAll("((\\r?\\n)|(\\r))$", "");
        switch (outputType) {
            case STDOUT: {
                this.logger.infof("%s%s: %s", (Object)this.prefix, (Object)outputType, (Object)utf8String);
                break;
            }
            case STDERR: {
                this.logger.errorf("%s%s: %s", (Object)this.prefix, (Object)outputType, (Object)utf8String);
                break;
            }
            case END: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected outputType " + String.valueOf(outputType));
            }
        }
    }
}

