/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestServer;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.model.Statement;

public class InfinispanServerRule
implements TestRule {
    private static final Log log = LogFactory.getLog(InfinispanServerRule.class);
    private final TestServer testServer;
    protected final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();

    public InfinispanServerRule(InfinispanServerTestConfiguration configuration) {
        this.testServer = new TestServer(configuration);
    }

    public InfinispanServerDriver getServerDriver() {
        return this.testServer.getDriver();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                String testName = description.getTestClass().getName().replaceAll("\\$", "-");
                RunWith runWith = description.getTestClass().getAnnotation(RunWith.class);
                boolean inSuite = runWith != null && Suite.class.isAssignableFrom(runWith.value());
                boolean hasXsite = InfinispanServerRule.this.testServer.hasCrossSiteEnabled();
                if (!inSuite && !hasXsite) {
                    TestResourceTracker.testStarted((String)testName);
                }
                boolean manageServer = !InfinispanServerRule.this.testServer.isDriverInitialized();
                try {
                    if (manageServer) {
                        InfinispanServerRule.this.testServer.initServerDriver();
                        InfinispanServerRule.this.testServer.getDriver().prepare(testName);
                        InfinispanServerRule.this.testServer.beforeListeners();
                        InfinispanServerRule.this.configurationEnhancers.forEach(c -> c.accept(InfinispanServerRule.this.testServer.getDriver().getConfDir()));
                        InfinispanServerRule.this.testServer.getDriver().start(testName);
                    }
                    InfinispanServerRule.this.before(testName);
                    base.evaluate();
                }
                catch (Throwable e) {
                    log.error((Object)"Problem during the server initialization", e);
                    throw e;
                }
                finally {
                    InfinispanServerRule.this.after(testName);
                    if (manageServer) {
                        if (InfinispanServerRule.this.testServer.isDriverInitialized()) {
                            InfinispanServerRule.this.testServer.stopServerDriver(testName);
                        }
                        InfinispanServerRule.this.testServer.afterListeners();
                    }
                    if (!inSuite && !hasXsite) {
                        TestResourceTracker.testFinished((String)testName);
                    }
                }
            }
        };
    }

    private void before(String name) {
    }

    private void after(String name) {
    }

    public TestServer getTestServer() {
        return this.testServer;
    }

    public static Log getLog() {
        return log;
    }
}

