/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.generator.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.instancio.generator.Hint;

public final class ArrayHint
implements Hint<ArrayHint> {
    private static final ArrayHint EMPTY_HINT = ArrayHint.builder().build();
    private final boolean nullableElements;
    private final boolean shuffle;
    private final List<?> withElements;

    private ArrayHint(Builder builder) {
        this.nullableElements = builder.nullableElements;
        this.shuffle = builder.shuffle;
        this.withElements = builder.withElements == null ? Collections.emptyList() : Collections.unmodifiableList(builder.withElements);
    }

    public static ArrayHint empty() {
        return EMPTY_HINT;
    }

    public boolean nullableElements() {
        return this.nullableElements;
    }

    public boolean shuffle() {
        return this.shuffle;
    }

    public <T> List<T> withElements() {
        return this.withElements;
    }

    public String toString() {
        return new StringJoiner(", ", "ArrayHint[", "]").add("nullableElements=" + this.nullableElements).add("shuffle=" + this.shuffle).add("withElements=" + this.withElements).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean nullableElements;
        private boolean shuffle;
        private List<Object> withElements;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder nullableElements(boolean nullableElements) {
            this.nullableElements = nullableElements;
            return this;
        }

        public Builder shuffle(boolean shuffle) {
            this.shuffle = shuffle;
            return this;
        }

        public <T> Builder withElements(List<? extends T> elements) {
            if (elements == null) {
                return this;
            }
            if (this.withElements == null) {
                this.withElements = new ArrayList<Object>();
            }
            this.withElements.addAll(elements);
            return this;
        }

        public ArrayHint build() {
            return new ArrayHint(this);
        }
    }
}

