/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.instancio.assignment.AssignmentType;
import org.instancio.exception.InstancioException;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.Hints;
import org.instancio.generator.hints.ArrayHint;
import org.instancio.generator.hints.CollectionHint;
import org.instancio.generator.hints.MapHint;
import org.instancio.internal.ArrayElementNodePopulationFilter;
import org.instancio.internal.CallbackHandler;
import org.instancio.internal.FieldNodePopulationFilter;
import org.instancio.internal.GeneratedNullValueListener;
import org.instancio.internal.GenerationListener;
import org.instancio.internal.GeneratorFacade;
import org.instancio.internal.InternalModel;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.FieldAssigner;
import org.instancio.internal.assigners.MethodAssigner;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.ContainerAddFunction;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalContainerHint;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.ArrayUtils;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.RecordUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.SystemProperties;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstancioEngine {
    private static final Logger LOG = LoggerFactory.getLogger(InstancioEngine.class);
    private final GeneratorFacade generatorFacade;
    private final ModelContext<?> context;
    private final InternalNode rootNode;
    private final CallbackHandler callbackHandler;
    private final List<GenerationListener> listeners;
    private final AfterGenerate defaultAfterGenerate;
    private final boolean overwriteExistingValues;
    private final Assigner assigner;

    InstancioEngine(InternalModel<?> model) {
        this.context = model.getModelContext();
        this.rootNode = model.getRootNode();
        this.callbackHandler = new CallbackHandler(this.context);
        this.generatorFacade = new GeneratorFacade(this.context);
        this.defaultAfterGenerate = this.context.getSettings().get(Keys.AFTER_GENERATE_HINT);
        this.overwriteExistingValues = this.context.getSettings().get(Keys.OVERWRITE_EXISTING_VALUES);
        this.listeners = Arrays.asList(this.callbackHandler, new GeneratedNullValueListener(this.context));
        this.assigner = this.getAssigner();
    }

    private Assigner getAssigner() {
        Settings settings = this.context.getSettings();
        AssignmentType defaultAssignment = settings.get(Keys.ASSIGNMENT_TYPE);
        AssignmentType assignment = ObjectUtils.defaultIfNull(SystemProperties.getAssignmentType(), defaultAssignment);
        if (assignment == AssignmentType.FIELD) {
            return new FieldAssigner(settings);
        }
        if (assignment == AssignmentType.METHOD) {
            return new MethodAssigner(settings);
        }
        throw new InstancioException("Invalid assignment type: " + (Object)((Object)assignment));
    }

    <T> T createRootObject() {
        return ExceptionHandler.conditionalFailOnError(() -> {
            GeneratorResult result = this.createObject(this.rootNode);
            Object rootResult = result.getValue();
            this.callbackHandler.invokeCallbacks();
            this.context.reportWarnings();
            return rootResult;
        }).orElse(null);
    }

    private GeneratorResult createObject(InternalNode node) {
        LOG.trace("Processing: {}", (Object)node);
        if (node.getChildren().isEmpty()) {
            return this.generateValue(node);
        }
        if (node.is(NodeKind.ARRAY)) {
            return this.generateArray(node);
        }
        if (node.is(NodeKind.COLLECTION)) {
            return this.generateCollection(node);
        }
        if (node.is(NodeKind.MAP)) {
            return this.generateMap(node);
        }
        if (node.is(NodeKind.RECORD)) {
            return this.generateRecord(node);
        }
        if (node.is(NodeKind.CONTAINER)) {
            return this.generateContainer(node);
        }
        if (node.is(NodeKind.DEFAULT)) {
            return this.generatePojo(node);
        }
        throw new InstancioException(String.format("Unhandled node kind '%s' for %s", new Object[]{node.getNodeKind(), node}));
    }

    private GeneratorResult generateContainer(InternalNode node) {
        ContainerAddFunction addFunction;
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.isEmpty() || generatorResult.isIgnored()) {
            return generatorResult;
        }
        InternalContainerHint hint = ObjectUtils.defaultIfNull(generatorResult.getHints().get(InternalContainerHint.class), InternalContainerHint.empty());
        List<InternalNode> children = node.getChildren();
        if (generatorResult.containsNull() && hint.createFunction() != null) {
            Object[] args = new Object[children.size()];
            for (int j = 0; j < children.size(); ++j) {
                GeneratorResult childResult = this.createObject(children.get(j));
                args[j] = childResult.getValue();
            }
            Object result = hint.createFunction().create(args);
            generatorResult = GeneratorResult.create(result, generatorResult.getHints());
        }
        if ((addFunction = hint.addFunction()) != null) {
            for (int i = 0; i < hint.generateEntries(); ++i) {
                Object[] args = new Object[children.size()];
                for (int j = 0; j < children.size(); ++j) {
                    GeneratorResult childResult = this.createObject(children.get(j));
                    args[j] = childResult.getValue();
                }
                addFunction.addTo(generatorResult.getValue(), args);
            }
        }
        if (hint.buildFunction() != null) {
            Object builtContainer = hint.buildFunction().build(generatorResult.getValue());
            return GeneratorResult.create(builtContainer, generatorResult.getHints());
        }
        Optional<GeneratorResult> spiResult = this.substituteResult(node, generatorResult);
        return spiResult.orElse(generatorResult);
    }

    private Optional<GeneratorResult> substituteResult(InternalNode node, GeneratorResult generatorResult) {
        return this.context.getContainerFactories().stream().map(it -> it.createFromOtherFunction(node.getTargetClass(), node.getChildren().stream().map(InternalNode::getTargetClass).collect(Collectors.toList()))).filter(Objects::nonNull).findFirst().map(fn -> fn.apply(generatorResult.getValue())).map(replacedValue -> GeneratorResult.create(replacedValue, generatorResult.getHints()));
    }

    private GeneratorResult generatePojo(InternalNode node) {
        GeneratorResult nodeResult = this.generateValue(node);
        if (!nodeResult.containsNull()) {
            this.populateChildren(node.getChildren(), nodeResult);
        }
        return nodeResult;
    }

    private GeneratorResult generateMap(InternalNode node) {
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.containsNull() || node.getChildren().size() < 2) {
            return generatorResult;
        }
        Map map = (Map)generatorResult.getValue();
        InternalNode valueNode = node.getChildren().get(1);
        InternalNode keyNode = node.getChildren().get(0);
        Hints hints = generatorResult.getHints();
        for (Map.Entry entry : map.entrySet()) {
            List<InternalNode> keyNodeChildren = keyNode.getChildren();
            List<InternalNode> valueNodeChildren = valueNode.getChildren();
            this.populateChildren(keyNodeChildren, GeneratorResult.create(entry.getKey(), hints));
            this.populateChildren(valueNodeChildren, GeneratorResult.create(entry.getValue(), hints));
        }
        if (keyNode.is(NodeKind.IGNORED) || valueNode.is(NodeKind.IGNORED)) {
            return generatorResult;
        }
        MapHint hint = ObjectUtils.defaultIfNull(hints.get(MapHint.class), MapHint.empty());
        boolean nullableKey = hint.nullableMapKeys();
        boolean nullableValue = hint.nullableMapValues();
        Iterator withKeysIterator = hint.withKeys().iterator();
        int entriesToGenerate = hint.generateEntries();
        int failedAdditions = 0;
        while (entriesToGenerate > 0) {
            Object mapKey;
            GeneratorResult mapValueResult = this.createObject(valueNode, nullableValue);
            Object mapValue = mapValueResult.getValue();
            Object object = mapKey = withKeysIterator.hasNext() ? withKeysIterator.next() : this.createObject(keyNode, nullableKey).getValue();
            if ((mapKey != null || nullableKey) && (mapValue != null || nullableValue || mapValueResult.hasEmitNullHint())) {
                if (!map.containsKey(mapKey)) {
                    map.put(mapKey, mapValue);
                    --entriesToGenerate;
                } else {
                    ++failedAdditions;
                }
            } else {
                ++failedAdditions;
            }
            if (failedAdditions <= 1000) continue;
            ExceptionHandler.conditionalFailOnError(() -> {
                throw new InstancioException("Unable to populate " + Format.withoutPackage(node.getType()) + " with requested number of entries: " + hint.generateEntries());
            });
            break;
        }
        if (!hint.withEntries().isEmpty()) {
            map.putAll(hint.withEntries());
        }
        Optional<GeneratorResult> spiResult = this.substituteResult(node, generatorResult);
        return spiResult.orElse(generatorResult);
    }

    private GeneratorResult generateArray(InternalNode node) {
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.containsNull() || node.getChildren().isEmpty()) {
            return generatorResult;
        }
        Object arrayObj = generatorResult.getValue();
        Hints hints = generatorResult.getHints();
        ArrayHint hint = ObjectUtils.defaultIfNull(hints.get(ArrayHint.class), ArrayHint.empty());
        List withElements = hint.withElements();
        int arrayLength = Array.getLength(arrayObj);
        InternalNode elementNode = node.getOnlyChild();
        int lastIndex = 0;
        int j = 0;
        for (int i = 0; i < arrayLength && j < withElements.size(); ++i) {
            Object elementValue = Array.get(arrayObj, i);
            if (elementValue != null) {
                List<InternalNode> elementNodeChildren = node.getOnlyChild().getChildren();
                this.populateChildren(elementNodeChildren, GeneratorResult.create(elementValue, hints));
            }
            if (!ReflectionUtils.neitherNullNorPrimitiveWithDefaultValue(elementNode.getRawType(), elementValue)) {
                Array.set(arrayObj, i, withElements.get(j));
                ++j;
            }
            lastIndex = i + 1;
        }
        AfterGenerate action = hints.afterGenerate();
        ArrayElementNodePopulationFilter filter = new ArrayElementNodePopulationFilter(this.context);
        boolean isPrimitiveArray = elementNode.getRawType().isPrimitive();
        int failedAdditions = 0;
        for (int i = lastIndex; i < arrayLength; ++i) {
            Object currentValue = Array.get(arrayObj, i);
            if (currentValue != null) {
                List<InternalNode> elementNodeChildren = node.getOnlyChild().getChildren();
                this.populateChildren(elementNodeChildren, GeneratorResult.create(currentValue, hints));
            }
            if (filter.shouldSkip(elementNode, action, currentValue)) continue;
            GeneratorResult elementResult = this.createObject(elementNode, hint.nullableElements());
            Object elementValue = elementResult.getValue();
            while (!(elementValue != null || hint.nullableElements() || elementResult.hasEmitNullHint() || this.context.isIgnored(elementNode) || failedAdditions >= 1000)) {
                ++failedAdditions;
                elementValue = this.createObject(elementNode, false).getValue();
            }
            if (isPrimitiveArray && elementValue == null) continue;
            Array.set(arrayObj, i, elementValue);
        }
        if (hint.shuffle()) {
            ArrayUtils.shuffle(arrayObj, this.context.getRandom());
        }
        return generatorResult;
    }

    private GeneratorResult generateCollection(InternalNode node) {
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.containsNull() || node.getChildren().isEmpty()) {
            return generatorResult;
        }
        Collection collection = (Collection)generatorResult.getValue();
        InternalNode elementNode = node.getOnlyChild();
        Hints hints = generatorResult.getHints();
        for (Object element : collection) {
            List<InternalNode> elementNodeChildren = elementNode.getChildren();
            this.populateChildren(elementNodeChildren, GeneratorResult.create(element, hints));
        }
        if (elementNode.is(NodeKind.IGNORED)) {
            return generatorResult;
        }
        CollectionHint hint = ObjectUtils.defaultIfNull(hints.get(CollectionHint.class), CollectionHint.empty());
        boolean nullableElements = hint.nullableElements();
        boolean requireUnique = hint.unique();
        HashSet<Object> generated = new HashSet<Object>();
        int elementsToGenerate = hint.generateElements();
        int failedAdditions = 0;
        while (elementsToGenerate > 0) {
            GeneratorResult elementResult = this.createObject(elementNode, nullableElements);
            Object elementValue = elementResult.getValue();
            if (elementValue != null || nullableElements || elementResult.hasEmitNullHint()) {
                boolean canAdd;
                boolean bl = canAdd = !requireUnique || !generated.contains(elementValue);
                if (requireUnique) {
                    generated.add(elementValue);
                }
                if (canAdd && collection.add(elementValue)) {
                    --elementsToGenerate;
                } else {
                    ++failedAdditions;
                }
            } else {
                ++failedAdditions;
            }
            if (failedAdditions <= 1000) continue;
            ExceptionHandler.conditionalFailOnError(() -> {
                throw new InstancioException("Unable to populate " + Format.withoutPackage(node.getType()) + " with requested number of elements: " + hint.generateElements());
            });
            break;
        }
        if (!hint.withElements().isEmpty()) {
            collection.addAll(hint.withElements());
        }
        if (hint.shuffle()) {
            CollectionUtils.shuffle(collection, this.context.getRandom());
        }
        Optional<GeneratorResult> spiResult = this.substituteResult(node, generatorResult);
        return spiResult.orElse(generatorResult);
    }

    private GeneratorResult generateRecord(InternalNode node) {
        Optional<Generator<?>> generator = this.context.getGenerator(node);
        if (!generator.isPresent()) {
            generator = this.generatorFacade.getGenerator(node);
        }
        if (generator.isPresent()) {
            return this.generateValue(node);
        }
        List<InternalNode> children = node.getChildren();
        Object[] args = new Object[children.size()];
        Class<?>[] ctorArgs = RecordUtils.getComponentTypes(node.getTargetClass());
        if (ctorArgs.length != args.length) {
            LOG.debug("Record {} has {} constructor arguments, but got {}", new Object[]{node.getTargetClass(), ctorArgs.length, args.length});
            return GeneratorResult.nullResult();
        }
        for (int i = 0; i < args.length; ++i) {
            InternalNode child = children.get(i);
            GeneratorResult result = this.createObject(child);
            args[i] = result.containsNull() ? ObjectUtils.defaultValue(ctorArgs[i]) : result.getValue();
        }
        try {
            Object obj = RecordUtils.instantiate(node.getTargetClass(), args);
            GeneratorResult generatorResult = GeneratorResult.create(obj, Hints.afterGenerate(this.defaultAfterGenerate));
            this.notifyListeners(node, generatorResult);
            return generatorResult;
        }
        catch (Exception ex) {
            ExceptionHandler.conditionalFailOnError(() -> {
                throw new InstancioException("Failed creating a record for: " + node, ex);
            });
            return GeneratorResult.emptyResult();
        }
    }

    private void populateChildren(List<InternalNode> children, GeneratorResult generatorResult) {
        if (generatorResult.containsNull()) {
            return;
        }
        Object value = generatorResult.getValue();
        AfterGenerate action = generatorResult.getHints().afterGenerate();
        FieldNodePopulationFilter filter = new FieldNodePopulationFilter(this.context);
        for (InternalNode child : children) {
            GeneratorResult result;
            if (filter.shouldSkip(child, action, value) || (result = this.createObject(child)).isEmpty() || result.isIgnored()) continue;
            Object arg = result.getValue();
            Field field = child.getField();
            if (!this.overwriteExistingValues && ReflectionUtils.hasNonNullOrNonDefaultPrimitiveValue(field, value)) continue;
            this.assigner.assign(child, value, arg);
        }
    }

    @NotNull
    private GeneratorResult createObject(InternalNode node, boolean isNullable) {
        if (this.context.getRandom().diceRoll(isNullable)) {
            GeneratorResult nullResult = GeneratorResult.nullResult();
            this.notifyListeners(node, nullResult);
            return nullResult;
        }
        return this.createObject(node);
    }

    private GeneratorResult generateValue(InternalNode node) {
        GeneratorResult generatorResult = this.generatorFacade.generateNodeValue(node);
        this.notifyListeners(node, generatorResult);
        return generatorResult;
    }

    private void notifyListeners(InternalNode node, GeneratorResult result) {
        for (GenerationListener listener : this.listeners) {
            listener.objectCreated(node, result);
        }
    }
}

