/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import java.util.Locale;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.StringSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.specs.InternalLengthGeneratorSpec;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.instancio.support.Global;

public class StringGenerator
extends AbstractGenerator<String>
implements StringSpec {
    protected int minLength;
    protected int maxLength;
    private boolean allowEmpty;
    private String prefix;
    private String suffix;
    private StringType stringType = StringType.ALPHABETIC;
    private StringCase stringCase = StringCase.UPPER;
    private Generator<?> delegate;

    public void setDelegate(Generator<?> delegate) {
        this.delegate = delegate;
    }

    public StringGenerator() {
        this(Global.generatorContext());
    }

    public StringGenerator(GeneratorContext context) {
        super(context);
        Settings settings = context.getSettings();
        this.minLength = settings.get(Keys.STRING_MIN_LENGTH);
        this.maxLength = settings.get(Keys.STRING_MAX_LENGTH);
        super.nullable(settings.get(Keys.STRING_NULLABLE));
        this.allowEmpty = settings.get(Keys.STRING_ALLOW_EMPTY);
    }

    public final int getMinLength() {
        return this.minLength;
    }

    @Override
    public String apiMethod() {
        return "string()";
    }

    @Override
    public StringGenerator prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public StringGenerator suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public StringGenerator allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    @Override
    public StringSpec allowEmpty(boolean isAllowed) {
        this.allowEmpty = isAllowed;
        return this;
    }

    @Override
    public StringGenerator nullable() {
        super.nullable();
        if (this.delegate instanceof AbstractGenerator) {
            ((AbstractGenerator)this.delegate).nullable();
        }
        return this;
    }

    public StringGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        if (this.delegate instanceof AbstractGenerator) {
            ((AbstractGenerator)this.delegate).nullable(isNullable);
        }
        return this;
    }

    @Override
    public StringGenerator length(int length) {
        this.minLength = ApiValidator.validateLength(length);
        this.maxLength = length;
        return this;
    }

    @Override
    public StringGenerator length(int minLength, int maxLength) {
        this.minLength = ApiValidator.validateLength(minLength);
        this.maxLength = ApiValidator.validateLength(maxLength);
        ApiValidator.isTrue(minLength <= maxLength, "Min length must be less than or equal to max (%s, %s)", minLength, maxLength);
        if (this.delegate instanceof InternalLengthGeneratorSpec) {
            ((InternalLengthGeneratorSpec)((Object)this.delegate)).length(minLength, maxLength);
        }
        return this;
    }

    @Override
    public StringGenerator minLength(int length) {
        this.minLength = ApiValidator.validateLength(length);
        this.maxLength = NumberUtils.calculateNewMaxSize(this.maxLength, this.minLength);
        return this;
    }

    @Override
    public StringGenerator maxLength(int length) {
        this.maxLength = ApiValidator.validateLength(length);
        this.minLength = NumberUtils.calculateNewMinSize(this.minLength, this.maxLength);
        return this;
    }

    @Override
    public StringGenerator lowerCase() {
        this.stringCase = StringCase.LOWER;
        return this;
    }

    @Override
    public StringGenerator upperCase() {
        this.stringCase = StringCase.UPPER;
        return this;
    }

    @Override
    public StringGenerator mixedCase() {
        this.stringCase = StringCase.MIXED;
        return this;
    }

    @Override
    public StringGenerator alphaNumeric() {
        this.stringType = StringType.ALPHANUMERIC;
        return this;
    }

    @Override
    public StringGenerator digits() {
        this.stringType = StringType.DIGITS;
        return this;
    }

    @Override
    public StringGenerator hex() {
        this.stringType = StringType.HEX;
        return this;
    }

    @Override
    public String tryGenerateNonNull(Random random) {
        if (this.delegate != null) {
            Object result = this.delegate.generate(random);
            return result == null ? null : result.toString();
        }
        if (random.diceRoll(this.allowEmpty)) {
            return "";
        }
        int length = random.intRange(this.minLength, this.maxLength);
        char[] chars = this.getStringCharacters();
        String result = random.stringOf(length, chars);
        if (this.prefix != null) {
            result = this.prefix + result;
        }
        if (this.suffix != null) {
            result = result + this.suffix;
        }
        return result;
    }

    private char[] getStringCharacters() {
        if (this.stringCase == StringCase.UPPER) {
            return this.stringType.upperCaseChars;
        }
        if (this.stringCase == StringCase.LOWER) {
            return this.stringType.lowerCaseChars;
        }
        if (this.stringCase == StringCase.MIXED) {
            return this.stringType.mixedCaseChars;
        }
        throw new IllegalStateException("Unknown StringType: " + (Object)((Object)this.stringType));
    }

    private static enum StringType {
        ALPHABETIC(Chars.access$000(), Chars.access$100(), Chars.access$200()),
        ALPHANUMERIC(Chars.access$300(), Chars.access$400(), Chars.access$500()),
        DIGITS(Chars.access$600(), Chars.access$600(), Chars.access$600()),
        HEX(Chars.access$700(), Chars.access$800(), Chars.access$900());

        final char[] lowerCaseChars;
        final char[] upperCaseChars;
        final char[] mixedCaseChars;

        private StringType(char[] lowerCaseChars, char[] upperCaseChars, char[] mixedCaseChars) {
            this.lowerCaseChars = lowerCaseChars;
            this.upperCaseChars = upperCaseChars;
            this.mixedCaseChars = mixedCaseChars;
        }

        private static class Chars {
            private static final String DIGITS = "0123456789";
            private static final String ALPHABETIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            private static final char[] DIGIT_CHARS = "0123456789".toCharArray();
            private static final char[] UC_ALPHABETIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
            private static final char[] LC_ALPHABETIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT).toCharArray();
            private static final char[] MC_ALPHABETIC = ("ABCDEFGHIJKLMNOPQRSTUVWXYZ" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT)).toCharArray();
            private static final char[] LC_ALPHANUMERIC = ("0123456789" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT)).toCharArray();
            private static final char[] UC_ALPHANUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
            private static final char[] MC_ALPHANUMERIC = ("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT)).toCharArray();
            private static final char[] LC_HEX = "0123456789abcdef".toCharArray();
            private static final char[] UC_HEX = "0123456789ABCDEF".toCharArray();
            private static final char[] MC_HEX = "0123456789abcdefABCDEF".toCharArray();

            private Chars() {
            }

            static /* synthetic */ char[] access$000() {
                return LC_ALPHABETIC;
            }

            static /* synthetic */ char[] access$100() {
                return UC_ALPHABETIC;
            }

            static /* synthetic */ char[] access$200() {
                return MC_ALPHABETIC;
            }

            static /* synthetic */ char[] access$300() {
                return LC_ALPHANUMERIC;
            }

            static /* synthetic */ char[] access$400() {
                return UC_ALPHANUMERIC;
            }

            static /* synthetic */ char[] access$500() {
                return MC_ALPHANUMERIC;
            }

            static /* synthetic */ char[] access$600() {
                return DIGIT_CHARS;
            }

            static /* synthetic */ char[] access$700() {
                return LC_HEX;
            }

            static /* synthetic */ char[] access$800() {
                return UC_HEX;
            }

            static /* synthetic */ char[] access$900() {
                return MC_HEX;
            }
        }
    }

    private static enum StringCase {
        LOWER,
        UPPER,
        MIXED;

    }
}

