/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.nio.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import org.instancio.Random;
import org.instancio.exception.InstancioApiException;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.PathAsGeneratorSpec;
import org.instancio.generator.specs.PathSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.IOUtils;
import org.instancio.internal.util.StringUtils;
import org.instancio.support.Global;

public class PathGenerator
extends AbstractGenerator<Path>
implements PathSpec,
PathAsGeneratorSpec<Path> {
    private static final int DEFAULT_NAME_LENGTH = 16;
    private final List<String> directories;
    private boolean isTemp;
    private String prefix;
    private String suffix;
    private Generator<String> nameGenerator;
    private CreatePathType createPathType;
    private InputStream inputStream;

    public PathGenerator() {
        this(Global.generatorContext());
    }

    public PathGenerator(GeneratorContext context) {
        super(context);
        this.directories = Collections.emptyList();
    }

    public PathGenerator(GeneratorContext context, String ... directories) {
        super(context);
        this.directories = CollectionUtils.asList(directories);
    }

    @Override
    public String apiMethod() {
        return "path()";
    }

    @Override
    public PathGenerator tmp() {
        this.isTemp = true;
        return this;
    }

    @Override
    public PathGenerator prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public PathGenerator suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public PathGenerator name(Generator<String> nameGenerator) {
        this.nameGenerator = nameGenerator;
        return this;
    }

    @Override
    public PathGenerator createFile(InputStream content) {
        this.inputStream = content;
        this.createPathType = CreatePathType.FILE;
        return this;
    }

    @Override
    public PathGenerator createFile() {
        this.createPathType = CreatePathType.FILE;
        return this;
    }

    @Override
    public PathGenerator createDirectory() {
        this.createPathType = CreatePathType.DIRECTORY;
        return this;
    }

    public PathGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public Path tryGenerateNonNull(Random random) {
        Path directoryPath = this.getDirectoryPath();
        Path leafNameAsPath = this.getLeafNameAsPath(random);
        Path completePath = directoryPath == null ? leafNameAsPath : directoryPath.resolve(leafNameAsPath);
        return this.createIfNeeded(directoryPath, completePath);
    }

    private Path createIfNeeded(Path directoryPath, Path completePath) {
        try {
            return this.createPath(directoryPath, completePath);
        }
        catch (IOException ex) {
            throw new InstancioApiException(String.format("Error generating %s: %s", this.createPathType.name().toLowerCase(Locale.ENGLISH), completePath), ex);
        }
    }

    private Path createPath(Path directoryPath, Path completePath) throws IOException {
        if (this.createPathType == null) {
            return completePath;
        }
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        if (!Files.exists(completePath, new LinkOption[0])) {
            if (this.createPathType == CreatePathType.FILE) {
                Path file = Files.createFile(completePath, new FileAttribute[0]);
                if (this.inputStream != null) {
                    IOUtils.writeTo(file, this.inputStream);
                }
                return file;
            }
            if (this.createPathType == CreatePathType.DIRECTORY) {
                return Files.createDirectory(completePath, new FileAttribute[0]);
            }
        }
        return completePath;
    }

    private Path getLeafNameAsPath(Random random) {
        String name = this.nameGenerator == null ? random.lowerCaseAlphabetic(16) : this.nameGenerator.generate(random);
        String pathName = StringUtils.concatNonNull(this.prefix, name, this.suffix);
        ApiValidator.isFalse(StringUtils.isBlank(pathName), "Generated name must not be blank", new Object[0]);
        return Paths.get(pathName, new String[0]);
    }

    private Path getDirectoryPath() {
        Path result = null;
        Deque<String> dirs = this.getDirectories();
        if (dirs.size() == 1) {
            result = Paths.get(dirs.pollFirst(), new String[0]);
        } else if (dirs.size() > 1) {
            String first = dirs.pollFirst();
            String[] remainder = new String[dirs.size()];
            for (int i = 0; i < remainder.length; ++i) {
                remainder[i] = dirs.pollFirst();
            }
            result = Paths.get(first, remainder);
        }
        return result;
    }

    private Deque<String> getDirectories() {
        ArrayDeque<String> path = new ArrayDeque<String>(this.directories);
        if (this.isTemp) {
            String tmpDir = ApiValidator.notNull(System.getProperty("java.io.tmpdir"), "Cannot resolve temporary directory: 'java.io.tmpdir' system property is null", new Object[0]);
            path.addFirst(tmpDir);
        }
        return path;
    }

    private static enum CreatePathType {
        FILE,
        DIRECTORY;

    }
}

