/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.LoremIpsumSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.StringUtils;
import org.instancio.support.Global;

public class LoremIpsumGenerator
extends AbstractGenerator<String>
implements LoremIpsumSpec {
    private static final String[] WORD_BANK = new String[]{"ad", "adipiscing", "aliqua", "aliquip", "amet", "anim", "aute", "cillum", "commodo", "consectetur", "consequat", "culpa", "cupidatat", "deserunt", "do", "dolor", "dolore", "duis", "ea", "eiusmod", "elit", "enim", "esse", "est", "et", "eu", "ex", "excepteur", "exercitation", "fugiat", "id", "in", "incididunt", "ipsum", "irure", "labore", "laboris", "laborum", "lorem", "magna", "minim", "mollit", "nisi", "non", "nostrud", "nulla", "occaecat", "officia", "pariatur", "proident", "qui", "quis", "reprehenderit", "sed", "sint", "sit", "sunt", "tempor", "ullamco", "ut", "velit", "veniam", "voluptate"};
    private static final int AVG_WORD_LENGTH = 9;
    private int words = 50;
    private int paragraphs = 1;

    public LoremIpsumGenerator() {
        this(Global.generatorContext());
    }

    public LoremIpsumGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "loremIpsum()";
    }

    @Override
    public LoremIpsumGenerator words(int words) {
        ApiValidator.isTrue(words > 0, "Number of words must be greater than zero: %s", words);
        this.words = words;
        return this;
    }

    @Override
    public LoremIpsumGenerator paragraphs(int paragraphs) {
        ApiValidator.isTrue(paragraphs > 0, "Number of paragraphs must be greater than zero: %s", paragraphs);
        this.paragraphs = paragraphs;
        return this;
    }

    @Override
    public LoremIpsumGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        ApiValidator.isTrue(this.words >= this.paragraphs, "The number of paragraphs (%s) is greater than the number of words (%s)", this.paragraphs, this.words);
        int wordsPerParagraph = this.words / this.paragraphs;
        int remainder = this.words - wordsPerParagraph * this.paragraphs;
        StringBuilder sb = new StringBuilder(this.words * 9);
        for (int p = 0; p < this.paragraphs; ++p) {
            int remainingWords;
            int n = remainingWords = p == 0 ? wordsPerParagraph + remainder : wordsPerParagraph;
            while (remainingWords > 0) {
                int sentenceWords = Math.min(remainingWords, random.intRange(4, 20));
                LoremIpsumGenerator.appendSentence(random, sb, sentenceWords);
                if ((remainingWords -= sentenceWords) <= 0) continue;
                sb.append(' ');
            }
            if (p >= this.paragraphs - 1) continue;
            sb.append(System.lineSeparator()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static void appendSentence(Random random, StringBuilder sb, int words) {
        sb.append(StringUtils.capitalise(random.oneOf(WORD_BANK)));
        for (int i = 1; i < words; ++i) {
            sb.append(' ').append(random.oneOf(WORD_BANK));
        }
        sb.append('.');
    }
}

