/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NullableGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.specs.InternalLengthGeneratorSpec;
import org.instancio.internal.util.LuhnUtils;

public class LuhnGenerator
extends AbstractGenerator<String>
implements NullableGeneratorSpec<String>,
InternalLengthGeneratorSpec<String> {
    private static final int DEFAULT_SIZE = 16;
    private int minSize = 16;
    private int maxSize = 16;
    private int startIndex = -1;
    private int endIndex = -1;
    private int checkDigitIndex = -1;

    public LuhnGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    public LuhnGenerator nullable() {
        super.nullable();
        return this;
    }

    public LuhnGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    public LuhnGenerator startIndex(int idx) {
        ApiValidator.isTrue(idx >= 0, "Start index must not be negative: %s", idx);
        this.startIndex = idx;
        return this;
    }

    public LuhnGenerator endIndex(int idx) {
        ApiValidator.isTrue(idx >= 0, "End index must not be negative: %s", idx);
        this.endIndex = idx == Integer.MAX_VALUE ? this.maxSize - 1 : idx;
        return this;
    }

    public LuhnGenerator checkIndex(int idx) {
        ApiValidator.isTrue(idx >= 0, "Check digit index must not be negative: %s", idx);
        this.checkDigitIndex = idx;
        return this;
    }

    public LuhnGenerator length(int length) {
        ApiValidator.isTrue(length > 1, "Luhn-valid number length must be greater than 1, but was: %s", length);
        this.minSize = length;
        this.maxSize = length;
        return this;
    }

    public LuhnGenerator length(int min, int max) {
        ApiValidator.isTrue(min > 0 && max > 1, "Luhn-valid number length must be greater than 1, but was: length(%s, %s)", min, max);
        ApiValidator.isTrue(min <= max, "Min must be less than or equal to max", new Object[0]);
        this.minSize = min;
        this.maxSize = max;
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        int size = random.intRange(this.minSize, this.maxSize);
        int start = Math.max(0, this.startIndex);
        int end = this.endIndex == -1 ? size - 1 : this.endIndex;
        int actualSize = Math.max(size, this.endIndex);
        int check = this.checkDigitIndex == -1 ? end : this.checkDigitIndex;
        int payloadSize = end - start + 1;
        String digits = random.digits(payloadSize);
        char[] payloadChars = digits.toCharArray();
        int checkDigit = LuhnUtils.getCheckDigit(payloadChars);
        String result = new String(payloadChars);
        if (start > 0) {
            String prefix = random.digits(start);
            result = prefix + result;
        }
        if (end < actualSize) {
            String suffix = random.digits(actualSize - end - 1);
            result = result + suffix;
        }
        char[] resultChars = result.toCharArray();
        resultChars[check] = (char)(checkDigit + 48);
        return new String(resultChars);
    }
}

