/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.DurationSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.NumberUtils;
import org.instancio.support.Global;

public class DurationGenerator
extends AbstractGenerator<Duration>
implements DurationSpec {
    private Duration min = Duration.of(1L, ChronoUnit.NANOS);
    private Duration max = Duration.of(Constants.DURATION_MAX_NANOS, ChronoUnit.NANOS);
    private boolean allowZero;

    public DurationGenerator() {
        this(Global.generatorContext());
    }

    public DurationGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "duration()";
    }

    @Override
    public DurationGenerator min(long amount, TemporalUnit unit) {
        this.min = Duration.of(amount, unit);
        if (this.min.toNanos() > this.max.toNanos()) {
            Long newMax = NumberUtils.calculateNewMax(this.max.toNanos(), this.min.toNanos(), 50);
            this.max = Duration.of(newMax, ChronoUnit.NANOS);
        }
        return this;
    }

    @Override
    public DurationGenerator max(long amount, TemporalUnit unit) {
        this.max = Duration.of(amount, unit);
        if (this.max.toNanos() < this.min.toNanos()) {
            Long newMin = NumberUtils.calculateNewMin(this.min.toNanos(), this.max.toNanos(), 50);
            this.min = Duration.of(newMin, ChronoUnit.NANOS);
        }
        return this;
    }

    @Override
    public DurationGenerator of(long minAmount, long maxAmount, TemporalUnit unit) {
        ApiValidator.notNull(unit, "Unit must not be null", new Object[0]);
        ApiValidator.isTrue(minAmount <= maxAmount, "Minimum duration amount must be less than or equal to the maximum amount: of(%s, %s, %s)", minAmount, maxAmount, unit);
        this.min(minAmount, unit);
        this.max(maxAmount, unit);
        return this;
    }

    @Override
    public DurationGenerator allowZero() {
        this.allowZero = true;
        return this;
    }

    public DurationGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Duration tryGenerateNonNull(Random random) {
        return random.diceRoll(this.allowZero) ? Duration.ZERO : Duration.of(random.longRange(this.min.toNanos(), this.max.toNanos()), ChronoUnit.NANOS);
    }
}

