/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import org.instancio.generator.Generator;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

public class ArrayNodeHandler
implements NodeHandler {
    private final GeneratorResolver generatorResolver;
    private final ModelContext<?> context;
    private final GeneratorSpecProcessor beanValidationProcessors;

    public ArrayNodeHandler(ModelContext<?> context, GeneratorResolver generatorResolver, GeneratorSpecProcessor beanValidationProcessor) {
        this.context = context;
        this.generatorResolver = generatorResolver;
        this.beanValidationProcessors = beanValidationProcessor;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        if (node.getTargetClass().isArray()) {
            Generator<?> generator = this.generatorResolver.get(node).orElseThrow(() -> new IllegalStateException("Unable to get array generator for node: " + node));
            this.beanValidationProcessors.process(generator, node.getTargetClass(), node.getField());
            Object arrayObject = generator.generate(this.context.getRandom());
            return GeneratorResult.create(arrayObject, generator.hints());
        }
        return GeneratorResult.emptyResult();
    }
}

