/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import java.lang.reflect.Field;
import org.instancio.exception.InstancioApiException;
import org.instancio.generator.Hints;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.EmitGenerator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Format;

class EmitGeneratorHelper {
    private static final Hints EMIT_NULL_HINT = Hints.builder().with(InternalGeneratorHint.builder().emitNull(true).build()).build();
    private static final GeneratorResult NULL_RESULT = GeneratorResult.create(null, EMIT_NULL_HINT);
    private final ModelContext<?> modelContext;

    EmitGeneratorHelper(ModelContext<?> modelContext) {
        this.modelContext = modelContext;
    }

    GeneratorResult getResult(EmitGenerator<?> generator, InternalNode node) {
        if (generator.hasMore()) {
            Object result = generator.generate(this.modelContext.getRandom());
            return result == null ? NULL_RESULT : GeneratorResult.create(result, generator.hints());
        }
        EmitGenerator.WhenEmptyAction whenEmptyAction = generator.getWhenEmptyAction();
        if (whenEmptyAction == EmitGenerator.WhenEmptyAction.EMIT_NULL) {
            return NULL_RESULT;
        }
        if (whenEmptyAction == EmitGenerator.WhenEmptyAction.EMIT_RANDOM) {
            return GeneratorResult.emptyResult();
        }
        throw new InstancioApiException("No items left to emit() for " + this.getTargetDescription(node));
    }

    private String getTargetDescription(InternalNode node) {
        Field field = node.getField();
        if (field != null) {
            return "field " + field.getDeclaringClass().getSimpleName() + "." + field.getName();
        }
        return "class " + Format.withoutPackage(node.getTargetClass());
    }
}

