/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.internal.reflection.DefaultPackageFilter;
import org.instancio.internal.reflection.FieldCollector;
import org.instancio.internal.reflection.PackageFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclaredAndInheritedFieldsCollector
implements FieldCollector {
    private final Map<Class<?>, List<Field>> cache = new HashMap();
    private final PackageFilter packageFilter = new DefaultPackageFilter();

    @Override
    public List<Field> getFields(Class<?> klass) {
        List<Field> cached = this.cache.get(klass);
        if (cached != null) {
            return cached;
        }
        List<Field> collected = this.getFieldList(klass);
        this.cache.put(klass, collected);
        return collected;
    }

    @NotNull
    private List<Field> getFieldList(Class<?> klass) {
        Class<?> next = klass;
        ArrayList<Field> collected = new ArrayList<Field>();
        while (this.shouldCollectFrom(next)) {
            for (Field field : next.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                collected.add(field);
            }
            next = next.getSuperclass();
        }
        return collected;
    }

    private boolean shouldCollectFrom(@Nullable Class<?> c) {
        return c != null && !c.isInterface() && !c.isArray() && c != Object.class && !this.packageFilter.isExcluded(c.getPackage());
    }
}

