/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.FieldSelectorBuilder;
import org.instancio.PredicateSelector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.SelectorBuilder;
import org.instancio.internal.selectors.SelectorTargetKind;
import org.instancio.internal.util.Format;

public class FieldSelectorBuilderImpl
implements FieldSelectorBuilder,
SelectorBuilder {
    private final List<Predicate<Field>> fieldPredicates = new ArrayList<Predicate<Field>>(4);
    private final StringBuilder description = new StringBuilder("fields()");

    @Override
    public FieldSelectorBuilder named(String fieldName) {
        ApiValidator.notNull(fieldName, () -> Format.selectorErrorMessage("Field name must not be null.", "named", this.description.toString(), new Throwable()));
        this.fieldPredicates.add(field -> field.getName().equals(fieldName));
        this.description.append(".named(\"").append(fieldName).append("\")");
        return this;
    }

    @Override
    public FieldSelectorBuilder matching(String regex) {
        ApiValidator.notNull(regex, () -> Format.selectorErrorMessage("Regex must not be null.", "matching", this.description.toString(), new Throwable()));
        this.fieldPredicates.add(field -> field.getName().matches(regex));
        this.description.append(".matching(\"").append(regex).append("\")");
        return this;
    }

    @Override
    public FieldSelectorBuilder ofType(Class<?> fieldType) {
        ApiValidator.notNull(fieldType, () -> Format.selectorErrorMessage("Field type must not be null.", "ofType", this.description.toString(), new Throwable()));
        this.fieldPredicates.add(field -> fieldType.isAssignableFrom(field.getType()));
        this.description.append(".ofType(").append(fieldType.getSimpleName()).append(')');
        return this;
    }

    @Override
    public FieldSelectorBuilder declaredIn(Class<?> type) {
        ApiValidator.notNull(type, () -> Format.selectorErrorMessage("Declaring type must not be null.", "declaredIn", this.description.toString(), new Throwable()));
        this.fieldPredicates.add(field -> field.getDeclaringClass() == type);
        this.description.append(".declaredIn(").append(type.getSimpleName()).append(')');
        return this;
    }

    @Override
    public <A extends Annotation> FieldSelectorBuilder annotated(Class<? extends A> annotation) {
        ApiValidator.notNull(annotation, () -> Format.selectorErrorMessage("Field's declared annotation must not be null.", "annotated", this.description.toString(), new Throwable()));
        this.fieldPredicates.add(field -> field.getDeclaredAnnotation(annotation) != null);
        this.description.append(".annotated(").append(annotation.getSimpleName()).append(')');
        return this;
    }

    @Override
    public PredicateSelector build() {
        Predicate<Field> predicate = Objects::nonNull;
        for (Predicate<Field> p : this.fieldPredicates) {
            predicate = predicate.and(p);
        }
        return new PredicateSelectorImpl(SelectorTargetKind.FIELD, predicate, null, this.description.toString());
    }

    public String toString() {
        return this.description.toString();
    }
}

