/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.settings;

import java.util.Objects;
import java.util.UUID;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.settings.AutoAdjustable;
import org.instancio.internal.settings.RangeAdjuster;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalKey<T>
implements SettingKey<T>,
AutoAdjustable,
Comparable<SettingKey<T>> {
    private final String propertyKey;
    private final Class<?> type;
    private final Object defaultValue;
    private final RangeAdjuster rangeAdjuster;
    private final boolean allowsNullValue;

    public InternalKey(String propertyKey, Class<?> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster, boolean allowsNullValue) {
        this.propertyKey = propertyKey;
        this.type = type;
        this.defaultValue = defaultValue;
        this.rangeAdjuster = rangeAdjuster;
        this.allowsNullValue = allowsNullValue;
    }

    @Override
    public String propertyKey() {
        return this.propertyKey;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    public T defaultValue() {
        return (T)this.defaultValue;
    }

    @Override
    public boolean allowsNullValue() {
        return this.allowsNullValue;
    }

    @Override
    public <N extends Number> void autoAdjust(@NotNull Settings settings, @NotNull N otherValue) {
        if (this.rangeAdjuster != null) {
            InternalKey key = this;
            this.rangeAdjuster.adjustRange(settings, key, otherValue);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SettingKey)) {
            return false;
        }
        SettingKey key = (SettingKey)o;
        return Objects.equals(this.propertyKey, key.propertyKey());
    }

    public int hashCode() {
        return Objects.hash(this.propertyKey);
    }

    @Override
    public int compareTo(SettingKey<T> o) {
        return this.propertyKey.compareTo(o.propertyKey());
    }

    public String toString() {
        return String.format("SettingKey[propertyKey=%s, type=%s]", this.propertyKey, this.type.getSimpleName());
    }

    public static <T> SettingKey.SettingKeyBuilder<T> builder(Class<T> type) {
        return new InternalKeyBuilder(type);
    }

    public static final class InternalKeyBuilder<T>
    implements SettingKey.SettingKeyBuilder<T> {
        private final Class<T> type;
        private String propertyKey;

        private InternalKeyBuilder(Class<T> type) {
            this.type = ApiValidator.notNull(type, "Type must not be null", new Object[0]);
        }

        @Override
        public SettingKey.SettingKeyBuilder<T> ofType(Class<T> type) {
            return new InternalKeyBuilder<T>(type);
        }

        @Override
        public SettingKey.SettingKeyBuilder<T> withPropertyKey(String propertyKey) {
            this.propertyKey = ApiValidator.notNull(propertyKey, "Property key must not be null", new Object[0]);
            return this;
        }

        @Override
        public SettingKey<T> create() {
            String key = this.propertyKey == null ? "custom.key." + UUID.randomUUID().toString().replace("-", "").substring(0, 20) : this.propertyKey;
            return new InternalKey(key, this.type, null, null, true);
        }
    }
}

