/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.instancio.assignment.AssignmentType;
import org.instancio.assignment.OnSetMethodError;
import org.instancio.assignment.OnSetMethodNotFound;
import org.instancio.assignment.SetterStyle;
import org.instancio.exception.InstancioApiException;
import org.instancio.exception.InstancioException;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.AssignerErrorUtil;
import org.instancio.internal.assigners.AssignerUtil;
import org.instancio.internal.assigners.FieldAssigner;
import org.instancio.internal.assigners.MethodNameResolver;
import org.instancio.internal.assigners.SetterMethodNameNoPrefix;
import org.instancio.internal.assigners.SetterMethodNameWithPrefixResolver;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodAssigner
implements Assigner {
    private static final Logger LOG = LoggerFactory.getLogger(MethodAssigner.class);
    private final Assigner fieldAssigner;
    private final Settings settings;
    private final MethodNameResolver setterNameResolver;
    private final int excludedModifiers;

    MethodAssigner(Settings settings) {
        this.settings = settings;
        this.setterNameResolver = MethodAssigner.getMethodNameResolver(settings.get(Keys.SETTER_STYLE));
        this.fieldAssigner = new FieldAssigner(settings);
        this.excludedModifiers = settings.get(Keys.SETTER_EXCLUDE_MODIFIER);
        LOG.trace("{}, {}, {}, {}", new Object[]{AssignmentType.METHOD, settings.get(Keys.SETTER_STYLE), settings.get(Keys.ON_SET_METHOD_NOT_FOUND), settings.get(Keys.ON_SET_METHOD_ERROR)});
    }

    private static MethodNameResolver getMethodNameResolver(SetterStyle style) {
        switch (style) {
            case SET: {
                return new SetterMethodNameWithPrefixResolver("set");
            }
            case WITH: {
                return new SetterMethodNameWithPrefixResolver("with");
            }
            case PROPERTY: {
                return new SetterMethodNameNoPrefix();
            }
        }
        throw Fail.withFataInternalError("Unhandled setter style: %s", new Object[]{style});
    }

    @Override
    public void assign(InternalNode node, Object target, Object arg) {
        Field field = node.getField();
        if (arg != null) {
            if (Modifier.isFinal(field.getModifiers())) {
                this.fieldAssigner.assign(node, target, arg);
            } else {
                this.assignViaMethod(node, target, arg);
            }
        } else if (!field.getType().isPrimitive()) {
            this.assignViaMethod(node, target, null);
        }
    }

    private void assignViaMethod(InternalNode node, Object target, Object arg) {
        String methodName = this.setterNameResolver.resolveFor(node.getField());
        Optional<Method> methodOpt = this.resolveSetterMethod(methodName, node.getField());
        if (methodOpt.isPresent()) {
            Method method = methodOpt.get();
            if (AssignerUtil.isExcluded(method.getModifiers(), this.excludedModifiers)) {
                return;
            }
            try {
                method.setAccessible(true);
                method.invoke(target, arg);
            }
            catch (IllegalAccessException ex) {
                throw new InstancioException("Error setting value via method: " + method, ex);
            }
            catch (Exception ex) {
                this.handleMethodInvocationError(node, target, arg, method, ex);
            }
        } else {
            this.handleMethodNotFoundError(node, target, arg, methodName);
        }
    }

    private void handleMethodInvocationError(InternalNode node, Object target, Object arg, Method method, Exception ex) {
        OnSetMethodError onSetMethodError = this.settings.get(Keys.ON_SET_METHOD_ERROR);
        if (onSetMethodError == OnSetMethodError.FAIL) {
            String methodName = Format.formatMethod(method);
            String errorMsg = AssignerErrorUtil.getSetterInvocationErrorMessage(arg, methodName, ex, this.settings);
            throw new InstancioApiException(errorMsg, ex);
        }
        if (onSetMethodError == OnSetMethodError.ASSIGN_FIELD) {
            ExceptionHandler.logException("Error invoking method {}, assigning value using field: {}", ex, method, node.getField());
            this.fieldAssigner.assign(node, target, arg);
        } else if (onSetMethodError == OnSetMethodError.IGNORE) {
            ExceptionHandler.logException("{}: error invoking method: {}", ex, new Object[]{OnSetMethodError.IGNORE, method});
        }
    }

    private void handleMethodNotFoundError(InternalNode node, Object target, Object arg, String methodName) {
        OnSetMethodNotFound onSetMethodNotFound = this.settings.get(Keys.ON_SET_METHOD_NOT_FOUND);
        if (onSetMethodNotFound == OnSetMethodNotFound.FAIL) {
            throw new InstancioApiException(AssignerErrorUtil.setterNotFound(node.getField(), methodName, this.settings));
        }
        if (onSetMethodNotFound == OnSetMethodNotFound.ASSIGN_FIELD) {
            LOG.trace("Could not resolve setter method, assigning value using field: {}", (Object)node.getField());
            this.fieldAssigner.assign(node, target, arg);
        } else if (onSetMethodNotFound == OnSetMethodNotFound.IGNORE) {
            LOG.debug("{}: class {} has no setter method: {}", new Object[]{OnSetMethodNotFound.IGNORE, target.getClass().getName(), methodName});
        }
    }

    private Optional<Method> resolveSetterMethod(String methodName, Field field) {
        if (methodName != null) {
            try {
                Class<?> klass = field.getDeclaringClass();
                return Optional.of(klass.getDeclaredMethod(methodName, field.getType()));
            }
            catch (NoSuchMethodException ex) {
                ExceptionHandler.logException("Resolved setter method '{}' for field '{}' does not exist", ex, methodName, Format.formatField(field));
            }
        }
        return Optional.empty();
    }
}

