/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.beanvalidation.AbstractBeanValidationProvider;
import org.instancio.internal.beanvalidation.AnnotationMap;
import org.instancio.internal.beanvalidation.BeanValidationProvider;
import org.instancio.internal.beanvalidation.HibernateBeanValidationProcessor;
import org.instancio.internal.beanvalidation.JakartaBeanValidationProcessor;
import org.instancio.internal.beanvalidation.JavaxBeanValidationProcessor;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanValidationProcessor
implements GeneratorSpecProcessor {
    private static final String JAVAX_VALIDATOR_CLASS = "javax.validation.Validation";
    private static final String JAKARTA_VALIDATOR_CLASS = "jakarta.validation.Validation";
    private static final String HIBERNATE_VALIDATOR_CLASS = "org.hibernate.validator.HibernateValidator";
    private final List<BeanValidationProvider> validationProviders = BeanValidationProcessor.initValidationProviders();

    @Override
    public void process(@NotNull GeneratorSpec<?> spec, @NotNull Class<?> targetClass, @Nullable Field field) {
        if (field == null) {
            return;
        }
        Annotation[] annotations = field.getDeclaredAnnotations();
        AnnotationMap map = new AnnotationMap(annotations);
        block0: for (BeanValidationProvider provider : this.validationProviders) {
            for (Annotation annotation : annotations) {
                if (!provider.isPrimary(annotation.annotationType())) continue;
                map.setPrimary(annotation);
                provider.consumeAnnotations(map, spec, targetClass, field);
                continue block0;
            }
        }
        for (BeanValidationProvider provider : this.validationProviders) {
            provider.consumeAnnotations(map, spec, targetClass, field);
        }
    }

    private static List<BeanValidationProvider> initValidationProviders() {
        ArrayList<AbstractBeanValidationProvider> providers = new ArrayList<AbstractBeanValidationProvider>();
        if (ReflectionUtils.loadClass(HIBERNATE_VALIDATOR_CLASS) != null) {
            providers.add(new HibernateBeanValidationProcessor());
        }
        if (ReflectionUtils.loadClass(JAKARTA_VALIDATOR_CLASS) != null) {
            providers.add(new JakartaBeanValidationProcessor());
        }
        if (ReflectionUtils.loadClass(JAVAX_VALIDATOR_CLASS) != null) {
            providers.add(new JavaxBeanValidationProcessor());
        }
        return Collections.unmodifiableList(providers);
    }
}

