/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.hibernate.validator.constraints.CreditCardNumber;
import org.hibernate.validator.constraints.EAN;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.ISBN;
import org.hibernate.validator.constraints.LuhnCheck;
import org.hibernate.validator.constraints.Mod10Check;
import org.hibernate.validator.constraints.Mod11Check;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.constraints.UUID;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.beanvalidation.AbstractBeanValidationProvider;
import org.instancio.internal.beanvalidation.AnnotationHandlerResolver;
import org.instancio.internal.beanvalidation.HibernateBeanValidationHandlerResolver;
import org.instancio.internal.generator.checksum.LuhnGenerator;
import org.instancio.internal.generator.checksum.Mod10Generator;
import org.instancio.internal.generator.checksum.Mod11Generator;
import org.instancio.internal.generator.domain.finance.CreditCardNumberGenerator;
import org.instancio.internal.generator.domain.id.EanGenerator;
import org.instancio.internal.generator.domain.id.IsbnGenerator;
import org.instancio.internal.generator.domain.internet.EmailGenerator;
import org.instancio.internal.generator.net.URLGenerator;
import org.instancio.internal.generator.util.UUIDGenerator;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.StringUtils;
import org.jetbrains.annotations.NotNull;

final class HibernateBeanValidationProcessor
extends AbstractBeanValidationProvider {
    private final HibernateBeanValidationHandlerResolver resolver = HibernateBeanValidationHandlerResolver.getInstance();

    HibernateBeanValidationProcessor() {
        super(HibernateBeanValidationProcessor.buildMap());
    }

    private static Map<Class<? extends Annotation>, BiFunction<Annotation, GeneratorContext, Generator<?>>> buildMap() {
        HashMap map = new HashMap();
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(EAN.class, (annotation, context) -> HibernateBeanValidationProcessor.getEanGenerator((EAN)annotation, context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Email.class, (annotation, context) -> new EmailGenerator((GeneratorContext)context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(LuhnCheck.class, (annotation, context) -> HibernateBeanValidationProcessor.getLuhnGenerator((LuhnCheck)annotation, context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Mod10Check.class, (annotation, context) -> HibernateBeanValidationProcessor.getMod10Generator((Mod10Check)annotation, context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Mod11Check.class, (annotation, context) -> HibernateBeanValidationProcessor.getMod11Generator((Mod11Check)annotation, context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(CreditCardNumber.class, (annotation, context) -> new CreditCardNumberGenerator((GeneratorContext)context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(ISBN.class, (annotation, context) -> new IsbnGenerator((GeneratorContext)context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(UUID.class, (annotation, context) -> new UUIDGenerator((GeneratorContext)context)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(URL.class, (annotation, context) -> HibernateBeanValidationProcessor.getUrlGenerator((URL)annotation, context)));
        return map;
    }

    private static URLGenerator getUrlGenerator(URL url, GeneratorContext context) {
        URLGenerator urlGenerator = new URLGenerator(context).port(url.port());
        if (!StringUtils.isBlank(url.protocol())) {
            urlGenerator.protocol(url.protocol());
        }
        if (!StringUtils.isBlank(url.host())) {
            urlGenerator.host(random -> url.host());
        }
        return urlGenerator;
    }

    @NotNull
    private static EanGenerator getEanGenerator(EAN ean, GeneratorContext context) {
        EanGenerator generator = new EanGenerator(context);
        if (ean.type() == EAN.Type.EAN8) {
            generator.type8();
        }
        return generator;
    }

    private static LuhnGenerator getLuhnGenerator(LuhnCheck luhn, GeneratorContext context) {
        LuhnGenerator generator = new LuhnGenerator(context).startIndex(luhn.startIndex()).endIndex(luhn.endIndex());
        if (luhn.checkDigitIndex() != -1) {
            generator.checkDigitIndex(luhn.checkDigitIndex());
        }
        return generator;
    }

    private static Mod10Generator getMod10Generator(Mod10Check mod10, GeneratorContext context) {
        Mod10Generator generator = new Mod10Generator(context).startIndex(mod10.startIndex()).endIndex(mod10.endIndex()).multiplier(mod10.multiplier()).weight(mod10.weight());
        if (mod10.checkDigitIndex() != -1) {
            generator.checkDigitIndex(mod10.checkDigitIndex());
        }
        return generator;
    }

    private static Mod11Generator getMod11Generator(Mod11Check mod11, GeneratorContext context) {
        Mod11Generator generator = new Mod11Generator(context).startIndex(mod11.startIndex()).endIndex(mod11.endIndex()).threshold(mod11.threshold()).treatCheck10As(mod11.treatCheck10As()).treatCheck11As(mod11.treatCheck11As());
        if (mod11.processingDirection() == Mod11Check.ProcessingDirection.LEFT_TO_RIGHT) {
            generator.leftToRight();
        }
        if (mod11.checkDigitIndex() != -1) {
            generator.checkDigitIndex(mod11.checkDigitIndex());
        }
        return generator;
    }

    @Override
    protected AnnotationHandlerResolver getAnnotationHandlerResolver() {
        return this.resolver;
    }
}

