/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.instancio.internal.beanvalidation.CommonBeanValidationHandlerResolver;
import org.instancio.internal.beanvalidation.FieldAnnotationHandler;
import org.instancio.internal.util.ExceptionHandler;

final class JavaxBeanValidationHandlerResolver
extends CommonBeanValidationHandlerResolver {
    static JavaxBeanValidationHandlerResolver getInstance() {
        return Holder.INSTANCE;
    }

    private JavaxBeanValidationHandlerResolver() {
        super(JavaxBeanValidationHandlerResolver.initHandlers());
    }

    private static Map<Class<?>, FieldAnnotationHandler> initHandlers() {
        HashMap map = new HashMap();
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(DecimalMax.class, new DecimalMaxHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(DecimalMin.class, new DecimalMinHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Digits.class, new DigitsHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Future.class, new CommonBeanValidationHandlerResolver.FutureHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(FutureOrPresent.class, new CommonBeanValidationHandlerResolver.FutureHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Max.class, new MaxHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Min.class, new MinHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Negative.class, new CommonBeanValidationHandlerResolver.NegativeHandler(new BigDecimal("-0.5"))));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(NotBlank.class, new CommonBeanValidationHandlerResolver.NotEmptyHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(NotEmpty.class, new CommonBeanValidationHandlerResolver.NotEmptyHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(NotNull.class, new CommonBeanValidationHandlerResolver.NotNullHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(NegativeOrZero.class, new CommonBeanValidationHandlerResolver.NegativeHandler(BigDecimal.ZERO)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Past.class, new CommonBeanValidationHandlerResolver.PastHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(PastOrPresent.class, new CommonBeanValidationHandlerResolver.PastHandler()));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Positive.class, new CommonBeanValidationHandlerResolver.PositiveHandler(new BigDecimal("0.5"))));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(PositiveOrZero.class, new CommonBeanValidationHandlerResolver.PositiveHandler(BigDecimal.ZERO)));
        ExceptionHandler.runIgnoringTheNoClassDefFoundError(() -> map.put(Size.class, new SizeHandler()));
        return map;
    }

    private static class Holder {
        private static final JavaxBeanValidationHandlerResolver INSTANCE = new JavaxBeanValidationHandlerResolver();

        private Holder() {
        }
    }

    private static class SizeHandler
    extends CommonBeanValidationHandlerResolver.AbstractSizeHandler {
        private SizeHandler() {
        }

        @Override
        int getMin(Annotation annotation) {
            return ((Size)annotation).min();
        }

        @Override
        int getMax(Annotation annotation) {
            return ((Size)annotation).max();
        }
    }

    private static class MinHandler
    extends CommonBeanValidationHandlerResolver.AbstractMinHandler {
        private MinHandler() {
        }

        @Override
        long getValue(Annotation annotation) {
            return ((Min)annotation).value();
        }
    }

    private static class MaxHandler
    extends CommonBeanValidationHandlerResolver.AbstractMaxHandler {
        private MaxHandler() {
        }

        @Override
        long getValue(Annotation annotation) {
            return ((Max)annotation).value();
        }
    }

    private static class DigitsHandler
    extends CommonBeanValidationHandlerResolver.AbstractDigitsHandler {
        private DigitsHandler() {
        }

        @Override
        int getFraction(Annotation annotation) {
            return ((Digits)annotation).fraction();
        }

        @Override
        int getInteger(Annotation annotation) {
            return ((Digits)annotation).integer();
        }
    }

    private static class DecimalMinHandler
    extends CommonBeanValidationHandlerResolver.AbstractDecimalMinHandler {
        private DecimalMinHandler() {
        }

        @Override
        String getValue(Annotation annotation) {
            return ((DecimalMin)annotation).value();
        }
    }

    private static class DecimalMaxHandler
    extends CommonBeanValidationHandlerResolver.AbstractDecimalMaxHandler {
        private DecimalMaxHandler() {
        }

        @Override
        String getValue(Annotation annotation) {
            return ((DecimalMax)annotation).value();
        }
    }
}

