/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.finance;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.CreditCardSpec;
import org.instancio.internal.generator.checksum.BaseModCheckGenerator;
import org.instancio.internal.generator.domain.finance.CCTypeImpl;
import org.instancio.support.Global;
import org.jetbrains.annotations.VisibleForTesting;

public class CreditCardNumberGenerator
extends BaseModCheckGenerator
implements CreditCardSpec {
    private CCTypeImpl cardType;

    public CreditCardNumberGenerator() {
        super(Global.generatorContext());
    }

    public CreditCardNumberGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "creditCard()";
    }

    @Override
    public CreditCardNumberGenerator visa() {
        return this.cardType(CCTypeImpl.CC_VISA);
    }

    @Override
    public CreditCardNumberGenerator masterCard() {
        return this.cardType(CCTypeImpl.CC_MASTERCARD);
    }

    @VisibleForTesting
    CreditCardNumberGenerator cardType(CCTypeImpl cardType) {
        this.cardType = cardType;
        return this;
    }

    @Override
    public CreditCardNumberGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String payload(Random random) {
        this.cardType = this.cardType == null ? random.oneOf(CCTypeImpl.values()) : this.cardType;
        String payload = super.payload(random);
        String prefix = random.oneOf(this.cardType.getPrefixes()).toString();
        return prefix + payload.substring(prefix.length());
    }

    @Override
    protected int payloadLength() {
        return this.cardType.getLength() - 1;
    }
}

