/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.TypeMap;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class InternalNode {
    private static final InternalNode IGNORED_NODE = InternalNode.builder().type((Type)((Object)Object.class)).rawType(Object.class).targetClass(Object.class).nodeKind(NodeKind.IGNORED).children(Collections.emptyList()).nodeContext(NodeContext.builder().build()).build();
    private final NodeContext nodeContext;
    private final Type type;
    private final Class<?> rawType;
    private final Class<?> targetClass;
    private final Field field;
    private final InternalNode parent;
    private final TypeMap typeMap;
    private final NodeKind nodeKind;
    private final int depth;
    private List<InternalNode> children;

    private InternalNode(Builder builder) {
        this.nodeContext = builder.nodeContext;
        this.type = Verify.notNull(builder.type, "null type", new Object[0]);
        this.rawType = Verify.notNull(builder.rawType, "null rawType", new Object[0]);
        this.targetClass = Verify.notNull(builder.targetClass, "null targetClass", new Object[0]);
        this.field = builder.field;
        this.parent = builder.parent;
        this.children = builder.children == null ? Collections.emptyList() : Collections.unmodifiableList(builder.children);
        this.nodeKind = builder.nodeKind;
        this.typeMap = new TypeMap(this.type, this.nodeContext.getRootTypeMap(), builder.additionalTypeMap);
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
    }

    public static InternalNode ignoredNode() {
        return IGNORED_NODE;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public boolean is(NodeKind nodeKind) {
        return this.nodeKind == nodeKind;
    }

    boolean isContainer() {
        return this.is(NodeKind.COLLECTION) || this.is(NodeKind.MAP) || this.is(NodeKind.ARRAY) || this.is(NodeKind.CONTAINER);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.nodeContext = this.nodeContext;
        builder.type = this.type;
        builder.rawType = this.rawType;
        builder.targetClass = this.targetClass;
        builder.field = this.field;
        builder.parent = this.parent;
        builder.children = this.children;
        builder.nodeKind = this.nodeKind;
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NodeContext getNodeContext() {
        return this.nodeContext;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Field getField() {
        return this.field;
    }

    public InternalNode getParent() {
        return this.parent;
    }

    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    public InternalNode getOnlyChild() {
        Verify.state(this.getChildren().size() == 1, "Expected one child, but were %s", this.getChildren().size());
        return this.getChildren().get(0);
    }

    public List<InternalNode> getChildren() {
        return this.children;
    }

    void setChildren(List<InternalNode> children) {
        this.children = children;
    }

    public boolean hasAncestorEqualToSelf() {
        for (InternalNode ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor.equals(this)) {
                return true;
            }
            if (ancestor.getParent() != null) continue;
            return Objects.equals(ancestor.getTargetClass(), this.targetClass) && Objects.equals(ancestor.getType(), this.type);
        }
        return false;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalNode other = (InternalNode)o;
        return this.getTargetClass().equals(other.getTargetClass()) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.getField(), other.getField());
    }

    public int hashCode() {
        return Objects.hash(this.getTargetClass(), this.getType(), this.getField());
    }

    public String toString() {
        if (this.nodeKind == NodeKind.IGNORED) {
            return "Node[IGNORED]";
        }
        String nodeName = this.field == null ? Format.withoutPackage(this.targetClass) : Format.withoutPackage(this.parent.targetClass) + '.' + this.field.getName();
        return "Node[" + nodeName + ", depth=" + this.depth + ", #chn=" + this.children.size() + ", " + Format.withoutPackage(this.type) + ']';
    }

    public static final class Builder {
        private NodeContext nodeContext;
        private Type type;
        private Class<?> rawType;
        private Class<?> targetClass;
        private Field field;
        private InternalNode parent;
        private List<InternalNode> children;
        private NodeKind nodeKind;
        private Map<Type, Type> additionalTypeMap = Collections.emptyMap();

        private Builder() {
        }

        public Builder nodeContext(NodeContext nodeContext) {
            this.nodeContext = nodeContext;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder rawType(Class<?> rawType) {
            this.rawType = rawType;
            return this;
        }

        public Builder targetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder field(@Nullable Field field) {
            this.field = field;
            return this;
        }

        public Builder parent(@Nullable InternalNode parent) {
            this.parent = parent;
            return this;
        }

        public Builder children(List<InternalNode> children) {
            this.children = children;
            return this;
        }

        public Builder nodeKind(NodeKind nodeKind) {
            this.nodeKind = nodeKind;
            return this;
        }

        public Builder additionalTypeMap(Map<Type, Type> additionalTypeMap) {
            this.additionalTypeMap = additionalTypeMap;
            return this;
        }

        public InternalNode build() {
            return new InternalNode(this);
        }
    }
}

