/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.random;

import java.util.Random;
import org.instancio.internal.util.Verify;

public final class RandomDataGenerator {
    public static long nextLong(Random random, long lower, long upper) {
        Verify.closedRange(lower, upper);
        long max = upper - lower + 1L;
        if (max <= 0L) {
            long r;
            while ((r = random.nextLong()) < lower || r > upper) {
            }
            return r;
        }
        if (max < Integer.MAX_VALUE) {
            return lower + (long)random.nextInt((int)max);
        }
        return lower + RandomDataGenerator.nextLong(random, max);
    }

    private static long nextLong(Random random, long n) throws IllegalArgumentException {
        if (n > 0L) {
            long bits;
            long val;
            byte[] byteArray = new byte[8];
            do {
                random.nextBytes(byteArray);
                bits = 0L;
                for (byte b : byteArray) {
                    bits = bits << 8 | (long)b & 0xFFL;
                }
            } while ((bits &= Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L);
            return val;
        }
        throw new IllegalStateException("Not Strictly positive: " + n);
    }

    public static double nextDouble(Random random, double lower, double upper) {
        Verify.isTrue(lower <= upper, "Lower must be less than or equal to upper: %s, %s", lower, upper);
        Verify.isFalse(Double.isInfinite(lower), "Lower bound must not be infinite", new Object[0]);
        Verify.isFalse(Double.isInfinite(upper), "Upper bound must not be infinite", new Object[0]);
        double u = random.nextDouble();
        return u * upper + (1.0 - u) * lower;
    }

    private RandomDataGenerator() {
    }
}

