/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import org.instancio.assignment.AssignmentType;
import org.instancio.assignment.OnSetFieldError;
import org.instancio.assignment.OnSetMethodError;
import org.instancio.assignment.OnSetMethodNotFound;
import org.instancio.assignment.SetterStyle;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.StringUtils;

final class AssignerErrorUtil {
    private static final int INITIAL_SB_SIZE = 1024;

    private AssignerErrorUtil() {
    }

    static String getFieldAssignmentErrorMessage(Object value, String fieldName, Throwable cause) {
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ON_SET_FIELD_ERROR = ").append((Object)OnSetFieldError.FAIL).append(Constants.NL).append(Constants.NL).append("Error assigning value to field:").append(Constants.NL).append(" -> Field: ").append(fieldName).append(Constants.NL).append(" -> Argument type:  ").append(Format.withoutPackage(value.getClass())).append(Constants.NL).append(" -> Argument value: ").append(StringUtils.quoteToString(value)).append(Constants.NL).append(Constants.NL).append("Root cause: ").append(Constants.NL).append(" -> ").append(AssignerErrorUtil.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To ignore the error and leave the field uninitialised").append(Constants.NL).append(" -> Update Keys.ON_SET_FIELD_ERROR setting to: ").append((Object)OnSetFieldError.IGNORE).append(Constants.NL).toString();
    }

    static String getSetterNotFoundMessage(String fieldName, String expectedMethodName, SetterStyle setterStyle) {
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_NOT_FOUND = ").append((Object)OnSetMethodNotFound.FAIL).append(Constants.NL).append(Constants.NL).append("Setter method could not be resolved for field:").append(Constants.NL).append(" -> ").append(fieldName).append(Constants.NL).append(Constants.NL).append("Using:").append(Constants.NL).append(" -> Keys.SETTER_STYLE = ").append((Object)setterStyle).append(Constants.NL).append(" -> Expected method name: '").append(expectedMethodName).append('\'').append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Add the expected setter method").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_NOT_FOUND setting to:").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    static String getSetterInvocationErrorMessage(Object value, OnSetMethodError onSetMethodError, String method, Throwable cause) {
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_ERROR = ").append((Object)onSetMethodError).append(Constants.NL).append(Constants.NL).append("Method invocation failed:").append(Constants.NL).append(" -> Method: ").append(method).append(Constants.NL).append(" -> Argument type:  ").append(Format.withoutPackage(value.getClass())).append(Constants.NL).append(" -> Argument value: ").append(StringUtils.quoteToString(value)).append(Constants.NL).append(Constants.NL).append("Root cause: ").append(Constants.NL).append(" -> ").append(AssignerErrorUtil.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Address the root cause that triggered the exception").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_ERROR setting to").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

