/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.instancio.Random;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.generator.specs.BigDecimalGeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.MapGeneratorSpec;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.generator.specs.StringGeneratorSpec;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.internal.beanvalidation.AnnotationHandlerResolver;
import org.instancio.internal.beanvalidation.FieldAnnotationHandler;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.generator.util.CollectionGenerator;
import org.instancio.internal.generator.util.MapGenerator;
import org.instancio.internal.util.BeanValidationUtils;
import org.instancio.internal.util.IntRange;
import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.StringUtils;
import org.instancio.settings.Keys;

final class JakartaBeanValidationHandlerResolver
implements AnnotationHandlerResolver {
    private final Map<Class<?>, FieldAnnotationHandler> handlerMap = JakartaBeanValidationHandlerResolver.initHandlers();

    private JakartaBeanValidationHandlerResolver() {
    }

    static JakartaBeanValidationHandlerResolver getInstance() {
        return Holder.INSTANCE;
    }

    private static Map<Class<?>, FieldAnnotationHandler> initHandlers() {
        HashMap<Class<Size>, FieldAnnotationHandler> map = new HashMap<Class<Size>, FieldAnnotationHandler>();
        map.put(DecimalMax.class, new DecimalMaxHandler());
        map.put(DecimalMin.class, new DecimalMinHandler());
        map.put(Digits.class, new DigitsHandler());
        map.put(Future.class, new FutureHandler());
        map.put(FutureOrPresent.class, new FutureHandler());
        map.put(Max.class, new MaxHandler());
        map.put(Min.class, new MinHandler());
        map.put(Negative.class, new NegativeHandler(new BigDecimal("-0.5")));
        map.put(NotBlank.class, new NotEmptyHandler());
        map.put(NotEmpty.class, new NotEmptyHandler());
        map.put(NotNull.class, new NotNullHandler());
        map.put(NegativeOrZero.class, new NegativeHandler(BigDecimal.ZERO));
        map.put(Past.class, new PastHandler());
        map.put(PastOrPresent.class, new PastHandler());
        map.put(Positive.class, new PositiveHandler(new BigDecimal("0.5")));
        map.put(PositiveOrZero.class, new PositiveHandler(BigDecimal.ZERO));
        map.put(Size.class, new SizeHandler());
        return Collections.unmodifiableMap(map);
    }

    @Override
    public FieldAnnotationHandler resolveHandler(Annotation annotation) {
        return this.handlerMap.get(annotation.annotationType());
    }

    private static class Holder {
        private static final JakartaBeanValidationHandlerResolver INSTANCE = new JakartaBeanValidationHandlerResolver();

        private Holder() {
        }
    }

    private static class DecimalMaxHandler
    implements FieldAnnotationHandler {
        private DecimalMaxHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                String value = ((DecimalMax)annotation).value();
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                BigDecimal max = new BigDecimal(value);
                ((NumberGeneratorSpec)spec).max((Number)converter.apply(max));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            }
        }
    }

    private static class DecimalMinHandler
    implements FieldAnnotationHandler {
        private DecimalMinHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                String value = ((DecimalMin)annotation).value();
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                BigDecimal min = new BigDecimal(value);
                AbstractRandomNumberGeneratorSpec numSpec = (AbstractRandomNumberGeneratorSpec)spec;
                numSpec.min((Number)converter.apply(min));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            }
        }
    }

    private static class DigitsHandler
    implements FieldAnnotationHandler {
        private DigitsHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            Digits digits = (Digits)annotation;
            if (spec instanceof StringGenerator) {
                StringGenerator generator = (StringGenerator)spec;
                generator.digits().length(digits.integer()).allowEmpty(false);
                if (digits.fraction() > 0) {
                    Random random = generator.getContext().random();
                    String fraction = random.digits(digits.fraction());
                    generator.suffix("." + fraction);
                }
            } else if (spec instanceof NumberGeneratorSpec) {
                NumberGeneratorSpec numSpec = (NumberGeneratorSpec)spec;
                int integer = digits.integer();
                BigDecimal min = integer == 0 ? BigDecimal.ZERO : BigDecimal.TEN.pow(integer - 1);
                BigDecimal max = BigDecimal.TEN.pow(integer).subtract(BigDecimal.ONE);
                if (min.equals(BigDecimal.ZERO) && max.equals(BigDecimal.ZERO) && digits.fraction() > 0) {
                    max = new BigDecimal("0." + StringUtils.repeat("9", digits.fraction()));
                }
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                numSpec.min((Number)converter.apply(min));
                numSpec.max((Number)converter.apply(max));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
                if (spec instanceof BigDecimalGeneratorSpec) {
                    ((BigDecimalGeneratorSpec)spec).scale(digits.fraction());
                }
            }
        }
    }

    private static class FutureHandler
    implements FieldAnnotationHandler {
        private FutureHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof TemporalGeneratorSpec) {
                ((TemporalGeneratorSpec)spec).future();
            }
        }
    }

    private static class MaxHandler
    implements FieldAnnotationHandler {
        private MaxHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                Max max = (Max)annotation;
                Function<Long, Long> fromLongConverter = NumberUtils.longConverter(fieldType);
                ((NumberGeneratorSpec)spec).max((Number)fromLongConverter.apply(max.value()));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            }
        }
    }

    private static class MinHandler
    implements FieldAnnotationHandler {
        private MinHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                Min min = (Min)annotation;
                Function<Long, Long> fromLongConverter = NumberUtils.longConverter(fieldType);
                ((NumberGeneratorSpec)spec).min((Number)fromLongConverter.apply(min.value()));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            }
        }
    }

    private static class NegativeHandler
    implements FieldAnnotationHandler {
        private final BigDecimal max;

        NegativeHandler(BigDecimal max) {
            this.max = max;
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                NumberGeneratorSpec numSpec = (NumberGeneratorSpec)spec;
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                Object numberMinValue = NumberUtils.getMinValue(fieldType);
                numSpec.min((Number)converter.apply(new BigDecimal(numberMinValue.toString()))).max((Number)converter.apply(this.max));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            }
        }
    }

    private static class NotEmptyHandler
    implements FieldAnnotationHandler {
        private NotEmptyHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof StringGenerator) {
                StringGenerator generator = (StringGenerator)spec;
                generator.minLength(Math.max(generator.getMinLength(), 1)).nullable(false).allowEmpty(false);
            } else if (spec instanceof ArrayGenerator) {
                ((ArrayGenerator)spec).nullable(false).minLength((Integer)Keys.ARRAY_MIN_LENGTH.defaultValue());
            } else if (spec instanceof CollectionGenerator) {
                ((CollectionGenerator)spec).nullable(false).minSize((Integer)Keys.COLLECTION_MIN_SIZE.defaultValue());
            } else if (spec instanceof MapGenerator) {
                ((MapGenerator)spec).nullable(false).minSize((Integer)Keys.MAP_MIN_SIZE.defaultValue());
            }
        }
    }

    private static class NotNullHandler
    implements FieldAnnotationHandler {
        private NotNullHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof AbstractGenerator) {
                ((AbstractGenerator)spec).nullable(false);
            }
        }
    }

    private static class PastHandler
    implements FieldAnnotationHandler {
        private PastHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof TemporalGeneratorSpec) {
                ((TemporalGeneratorSpec)spec).past();
            }
        }
    }

    private static class PositiveHandler
    implements FieldAnnotationHandler {
        private final BigDecimal min;

        PositiveHandler(BigDecimal min) {
            this.min = min;
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof NumberGeneratorSpec) {
                NumberGeneratorSpec numSpec = (NumberGeneratorSpec)spec;
                Function<BigDecimal, BigDecimal> converter = NumberUtils.bigDecimalConverter(fieldType);
                Object numberMaxValue = NumberUtils.getMaxValue(fieldType);
                numSpec.min((Number)converter.apply(this.min)).max((Number)converter.apply(new BigDecimal(numberMaxValue.toString())));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            }
        }
    }

    private static class SizeHandler
    implements FieldAnnotationHandler {
        private SizeHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            Size size = (Size)annotation;
            if (spec instanceof StringGeneratorSpec) {
                IntRange range = BeanValidationUtils.calculateRange(size.min(), size.max(), (Integer)Keys.STRING_MAX_LENGTH.defaultValue());
                StringGeneratorSpec stringSpec = (StringGeneratorSpec)spec;
                stringSpec.length(range.min(), range.max());
                if (size.min() > 0) {
                    stringSpec.allowEmpty(false);
                }
            } else if (spec instanceof CollectionGeneratorSpec) {
                IntRange range = BeanValidationUtils.calculateRange(size.min(), size.max(), (Integer)Keys.COLLECTION_MAX_SIZE.defaultValue());
                ((CollectionGeneratorSpec)spec).minSize(range.min()).maxSize(range.max());
            } else if (spec instanceof MapGeneratorSpec) {
                IntRange range = BeanValidationUtils.calculateRange(size.min(), size.max(), (Integer)Keys.MAP_MAX_SIZE.defaultValue());
                ((MapGeneratorSpec)spec).minSize(range.min()).maxSize(range.max());
            } else if (spec instanceof ArrayGeneratorSpec) {
                IntRange range = BeanValidationUtils.calculateRange(size.min(), size.max(), (Integer)Keys.ARRAY_MAX_LENGTH.defaultValue());
                ((ArrayGeneratorSpec)spec).minLength(range.min()).maxLength(range.max());
            }
        }
    }
}

