/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.net;

import java.net.URI;
import java.net.URISyntaxException;
import org.instancio.Random;
import org.instancio.exception.InstancioApiException;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.URIAsStringGeneratorSpec;
import org.instancio.generator.specs.URISpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.net.AbstractURIGenerator;
import org.instancio.internal.util.StringUtils;

public class URIGenerator
extends AbstractURIGenerator<URI>
implements URISpec,
URIAsStringGeneratorSpec {
    private String userInfo;
    private Generator<String> queryGenerator;
    private Generator<String> fragmentGenerator;

    public URIGenerator() {
        this(Global.generatorContext());
    }

    public URIGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "uri()";
    }

    @Override
    public URIGenerator scheme(String ... schemes) {
        this.withScheme(schemes);
        return this;
    }

    @Override
    public URIGenerator userInfo(String userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    @Override
    public URIGenerator host(Generator<String> hostGenerator) {
        this.withHost(hostGenerator);
        return this;
    }

    @Override
    public URIGenerator port(int port) {
        this.withPort(port);
        return this;
    }

    @Override
    public URIGenerator randomPort() {
        this.withRandomPort();
        return this;
    }

    @Override
    public URIGenerator path(Generator<String> path) {
        this.withPath(path);
        return this;
    }

    @Override
    public URIGenerator query(Generator<String> queryGenerator) {
        this.queryGenerator = queryGenerator;
        return this;
    }

    @Override
    public URIGenerator fragment(Generator<String> fragmentGenerator) {
        this.fragmentGenerator = fragmentGenerator;
        return this;
    }

    @Override
    public URI generate(Random random) {
        String scheme = this.getScheme(random);
        int port = this.getPort(random);
        String host = this.getHost(random);
        String path = this.getPath(random, null);
        String query = this.queryGenerator == null ? null : this.queryGenerator.generate(random);
        String fragment = this.fragmentGenerator == null ? null : this.fragmentGenerator.generate(random);
        try {
            return new URI(scheme, this.userInfo, host, port, path, query, fragment);
        }
        catch (URISyntaxException ex) {
            String params = String.format("%n  scheme: %s%n  userInfo: %s%n  host: %s%n  port: %s%n  path: %s%n  query: %s%n  fragment: %s", StringUtils.singleQuote(scheme), StringUtils.singleQuote(this.userInfo), StringUtils.singleQuote(host), port, StringUtils.singleQuote(path), StringUtils.singleQuote(query), StringUtils.singleQuote(fragment));
            throw new InstancioApiException("Error generating a URI using parameters: " + params, ex);
        }
    }
}

