/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import java.util.Locale;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NullableGeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.specs.InternalLengthGeneratorSpec;
import org.instancio.internal.util.Verify;

public class EmailAddressGenerator
extends AbstractGenerator<String>
implements NullableGeneratorSpec<String>,
InternalLengthGeneratorSpec<String> {
    private static final String[] TLDS = new String[]{"com", "edu", "net", "org"};
    private int minLength = 7;
    private int maxLength = 24;

    public EmailAddressGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    public EmailAddressGenerator nullable() {
        super.nullable();
        return this;
    }

    public EmailAddressGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    public EmailAddressGenerator length(int min, int max) {
        Verify.isTrue(min >= 3, "Email length must be at least 3 characters long", new Object[0]);
        Verify.isTrue(min <= max, "Min must be less than or equal to max", new Object[0]);
        this.minLength = min;
        this.maxLength = max;
        return this;
    }

    public EmailAddressGenerator length(int length) {
        this.length(length, length);
        return this;
    }

    @Override
    public String generate(Random random) {
        if (random.diceRoll(this.isNullable())) {
            return null;
        }
        int len = random.intRange(this.minLength, this.maxLength);
        if (len >= 7) {
            String tld = "." + random.oneOf(TLDS);
            int rem = len - tld.length() - 1;
            return EmailAddressGenerator.emailWithoutTld(random, rem) + tld;
        }
        int rem = len - 1;
        return EmailAddressGenerator.emailWithoutTld(random, rem);
    }

    private static String emailWithoutTld(Random random, int length) {
        int localPartLen = random.intRange(1, length - 1);
        int domainLen = length - localPartLen;
        String localPart = random.alphanumeric(localPartLen).toLowerCase(Locale.ROOT);
        String domain = random.alphanumeric(domainLen).toLowerCase(Locale.ROOT);
        return localPart + '@' + domain;
    }
}

