/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Instant;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.InstantSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;

public class InstantGenerator
extends JavaTimeTemporalGenerator<Instant>
implements InstantSpec {
    private static final int MAX_NANO = 999999999;
    static final Instant DEFAULT_MIN = Constants.DEFAULT_MIN.atZone(Constants.ZONE_OFFSET).toInstant();
    static final Instant DEFAULT_MAX = Constants.DEFAULT_MAX.atZone(Constants.ZONE_OFFSET).toInstant();

    public InstantGenerator() {
        this(Global.generatorContext());
    }

    public InstantGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX);
    }

    @Override
    public String apiMethod() {
        return "instant()";
    }

    @Override
    public InstantGenerator past() {
        super.past();
        return this;
    }

    @Override
    public InstantGenerator future() {
        super.future();
        return this;
    }

    @Override
    public InstantGenerator range(Instant start, Instant end) {
        super.range(start, end);
        return this;
    }

    @Override
    public InstantGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    Instant getLatestPast() {
        return Instant.now().minusSeconds(1L);
    }

    @Override
    Instant getEarliestFuture() {
        return Instant.now().plusSeconds(60L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((Instant)this.min).compareTo((Instant)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public Instant generateNonNullValue(Random random) {
        long sec = random.longRange(((Instant)this.min).getEpochSecond(), ((Instant)this.max).getEpochSecond());
        int nano = sec == ((Instant)this.min).getEpochSecond() && sec == ((Instant)this.max).getEpochSecond() ? random.intRange(Math.min(((Instant)this.min).getNano(), ((Instant)this.max).getNano()), Math.max(((Instant)this.min).getNano(), ((Instant)this.max).getNano())) : (sec == ((Instant)this.min).getEpochSecond() ? random.intRange(Math.max(((Instant)this.min).getNano(), ((Instant)this.max).getNano()), 999999999) : (sec == ((Instant)this.max).getEpochSecond() ? random.intRange(0, ((Instant)this.max).getNano()) : random.intRange(0, 999999999)));
        return Instant.ofEpochSecond(sec, nano);
    }
}

