/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util.concurrent.atomic;

import java.util.concurrent.atomic.AtomicInteger;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;

public class AtomicIntegerGenerator
extends AbstractRandomNumberGeneratorSpec<AtomicInteger>
implements NumberGeneratorSpec<AtomicInteger> {
    private static final int DEFAULT_MIN = 1;
    private static final int DEFAULT_MAX = 10000;

    public AtomicIntegerGenerator(GeneratorContext context) {
        super(context, new AtomicInteger(1), new AtomicInteger(10000), false);
    }

    @Override
    public String apiMethod() {
        return "atomicInteger()";
    }

    @Override
    protected AtomicInteger generateNonNullValue(Random random) {
        return new AtomicInteger(random.intRange(((AtomicInteger)this.getMin()).intValue(), ((AtomicInteger)this.getMax()).intValue()));
    }
}

