/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import java.util.Optional;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.GeneratedValuePostProcessor;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.handlers.StringPrefixingPostProcessor;
import org.instancio.internal.nodes.Node;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsingGeneratorResolverHandler
implements NodeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UsingGeneratorResolverHandler.class);
    private final ModelContext<?> context;
    private final GeneratorResolver generatorResolver;
    private final GeneratorSpecProcessor beanValidationProcessors;
    private final GeneratedValuePostProcessor stringPostProcessor;

    public UsingGeneratorResolverHandler(ModelContext<?> context, GeneratorResolver generatorResolver, GeneratorSpecProcessor beanValidationProcessors) {
        this.context = context;
        this.generatorResolver = generatorResolver;
        this.stringPostProcessor = new StringPrefixingPostProcessor((Boolean)context.getSettings().get(Keys.STRING_FIELD_PREFIX_ENABLED));
        this.beanValidationProcessors = beanValidationProcessors;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull Node node) {
        Class<?> targetClass = node.getTargetClass();
        Optional<Generator<?>> generatorOpt = this.generatorResolver.get(targetClass);
        return generatorOpt.map(generator -> {
            LOG.trace("Using '{}' generator to create '{}'", (Object)generator.getClass().getSimpleName(), (Object)targetClass.getName());
            this.beanValidationProcessors.process((GeneratorSpec<?>)generator, node.getTargetClass(), node.getField());
            Object value = generator.generate(this.context.getRandom());
            Object processed = this.stringPostProcessor.process(value, node, (Generator<?>)generator);
            GeneratorResult result = GeneratorResult.create(processed, generator.hints());
            LOG.trace("Generated {} using '{}' generator ", (Object)result, (Object)generator.getClass().getSimpleName());
            return result;
        }).orElse(GeneratorResult.emptyResult());
    }
}

