/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.instancio.Mode;
import org.instancio.settings.Keys;
import org.instancio.settings.SettingKey;

final class SettingsSupport {
    private static final Map<Class<?>, Function<String, Object>> VALUE_OF_FUNCTIONS = SettingsSupport.createValueOfFunctionsMap();
    private static final Map<SettingKey, SettingKey> AUTO_ADJUSTABLE_MAP = SettingsSupport.getAutoAdjustableKeys();

    static Function<String, Object> getFunction(Class<?> type) {
        return VALUE_OF_FUNCTIONS.get(type);
    }

    static Optional<SettingKey> getAutoAdjustable(SettingKey key) {
        return Optional.ofNullable(AUTO_ADJUSTABLE_MAP.get(key));
    }

    private static Map<Class<?>, Function<String, Object>> createValueOfFunctionsMap() {
        HashMap<Class, Function<String, Object>> fnMap = new HashMap<Class, Function<String, Object>>();
        fnMap.put(Boolean.class, Boolean::valueOf);
        fnMap.put(Byte.class, Byte::valueOf);
        fnMap.put(Short.class, Short::valueOf);
        fnMap.put(Integer.class, Integer::valueOf);
        fnMap.put(Long.class, Long::valueOf);
        fnMap.put(Float.class, Float::valueOf);
        fnMap.put(Double.class, Double::valueOf);
        fnMap.put(Mode.class, Mode::valueOf);
        return Collections.unmodifiableMap(fnMap);
    }

    private static Map<SettingKey, SettingKey> getAutoAdjustableKeys() {
        HashMap<SettingKey, SettingKey> map = new HashMap<SettingKey, SettingKey>();
        map.put(Keys.ARRAY_MAX_LENGTH, Keys.ARRAY_MIN_LENGTH);
        map.put(Keys.ARRAY_MIN_LENGTH, Keys.ARRAY_MAX_LENGTH);
        map.put(Keys.BYTE_MAX, Keys.BYTE_MIN);
        map.put(Keys.BYTE_MIN, Keys.BYTE_MAX);
        map.put(Keys.COLLECTION_MAX_SIZE, Keys.COLLECTION_MIN_SIZE);
        map.put(Keys.COLLECTION_MIN_SIZE, Keys.COLLECTION_MAX_SIZE);
        map.put(Keys.DOUBLE_MAX, Keys.DOUBLE_MIN);
        map.put(Keys.DOUBLE_MIN, Keys.DOUBLE_MAX);
        map.put(Keys.FLOAT_MAX, Keys.FLOAT_MIN);
        map.put(Keys.FLOAT_MIN, Keys.FLOAT_MAX);
        map.put(Keys.INTEGER_MAX, Keys.INTEGER_MIN);
        map.put(Keys.INTEGER_MIN, Keys.INTEGER_MAX);
        map.put(Keys.LONG_MAX, Keys.LONG_MIN);
        map.put(Keys.LONG_MIN, Keys.LONG_MAX);
        map.put(Keys.MAP_MAX_SIZE, Keys.MAP_MIN_SIZE);
        map.put(Keys.MAP_MIN_SIZE, Keys.MAP_MAX_SIZE);
        map.put(Keys.SHORT_MAX, Keys.SHORT_MIN);
        map.put(Keys.SHORT_MIN, Keys.SHORT_MAX);
        map.put(Keys.STRING_MAX_LENGTH, Keys.STRING_MIN_LENGTH);
        map.put(Keys.STRING_MIN_LENGTH, Keys.STRING_MAX_LENGTH);
        return Collections.unmodifiableMap(map);
    }

    private SettingsSupport() {
    }
}

