/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import org.instancio.internal.util.Verify;

public final class IntRange {
    private final int min;
    private final int max;

    private IntRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static IntRange range(int min, int max) {
        Verify.isTrue(min <= max, "Min must be less than or equal to max: (%s, %s)", min, max);
        return new IntRange(min, max);
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public String toString() {
        return String.format("Range[%s, %s]", this.min, this.max);
    }
}

